/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.geometry;

import org.chsrobotics.lib.math.UtilityMath;
import org.chsrobotics.lib.math.geometry.Vector2D;

public class Line2D {
    private final Vector2D startPoint;
    private final Vector2D endPoint;

    public Line2D(Vector2D origin, double magnitude, double directionRadians) {
        this.startPoint = origin;
        this.endPoint = new Vector2D(magnitude * Math.cos(directionRadians), magnitude * Math.sin(directionRadians));
    }

    public Line2D(double magnitude, double directionRadians) {
        this(new Vector2D(0.0, 0.0), magnitude, directionRadians);
    }

    public Line2D(Vector2D origin, Vector2D end) {
        this.startPoint = origin;
        this.endPoint = end;
    }

    public Line2D(Vector2D end) {
        this(new Vector2D(0.0, 0.0), end);
    }

    public double getDirectionRadians() {
        if (this.getDeltaX() == 0.0) {
            return Double.NaN;
        }
        return Math.atan2(this.getDeltaY(), this.getDeltaX());
    }

    public double getMagnitude() {
        return this.endPoint.subtract(this.startPoint).getMagnitude();
    }

    public double getDeltaX() {
        return this.endPoint.subtract(this.startPoint).getX();
    }

    public double getDeltaY() {
        return this.endPoint.subtract(this.startPoint).getY();
    }

    public boolean pointOn(Vector2D point) {
        if (point.equals(this.startPoint) || point.equals(this.endPoint)) {
            return true;
        }
        if (this.getDeltaX() == 0.0) {
            return point.getX() == this.startPoint.getX() && UtilityMath.inRange(this.startPoint.getY(), this.endPoint.getY(), point.getY());
        }
        if (this.getDeltaY() == 0.0) {
            return point.getY() == this.startPoint.getY() && UtilityMath.inRange(this.startPoint.getX(), this.endPoint.getX(), point.getX());
        }
        if (this.startPoint.getX() - point.getX() == 0.0) {
            return false;
        }
        boolean colinear = UtilityMath.epsilonEqualsAbsolute(this.getDeltaY() / this.getDeltaX(), (point.getY() - this.startPoint.getY()) / (point.getX() - this.startPoint.getX()));
        return colinear && UtilityMath.inRange(this.startPoint.getX(), this.endPoint.getX(), point.getX()) && UtilityMath.inRange(this.startPoint.getY(), this.endPoint.getY(), point.getY());
    }

    public boolean intersects(Line2D other) {
        double yCoord;
        if (UtilityMath.normalizeAngleRadians(this.getDirectionRadians()) == UtilityMath.normalizeAngleRadians(other.getDirectionRadians()) || Double.isNaN(this.getDirectionRadians()) && Double.isNaN(other.getDirectionRadians())) {
            boolean otherStartpointInThis = UtilityMath.inRange(this.getStartPoint().getX(), this.getEndPoint().getX(), other.getStartPoint().getX()) && UtilityMath.inRange(this.getStartPoint().getY(), this.getEndPoint().getY(), other.getStartPoint().getY());
            boolean thisStartpointInOther = UtilityMath.inRange(other.getStartPoint().getX(), other.getEndPoint().getX(), this.getStartPoint().getX()) && UtilityMath.inRange(other.getStartPoint().getY(), other.getEndPoint().getY(), this.getStartPoint().getY());
            return otherStartpointInThis || thisStartpointInOther;
        }
        if (other.getDeltaX() == 0.0) {
            double thisOffset = this.getStartPoint().getY() - Math.tan(this.getDirectionRadians()) * this.getStartPoint().getX();
            double intercept = Math.tan(this.getDirectionRadians()) * other.getStartPoint().getX() + thisOffset;
            return other.pointOn(new Vector2D(other.getStartPoint().getX(), intercept)) && this.pointOn(new Vector2D(other.getStartPoint().getX(), intercept));
        }
        if (this.getDeltaX() == 0.0) {
            double otherOffset = other.getStartPoint().getY() - Math.tan(other.getDirectionRadians()) * other.getStartPoint().getX();
            double intercept = Math.tan(other.getDirectionRadians()) * this.getStartPoint().getX() + otherOffset;
            return this.pointOn(new Vector2D(this.getStartPoint().getX(), intercept)) && other.pointOn(new Vector2D(this.getStartPoint().getX(), intercept));
        }
        double thisOffset = this.getStartPoint().getY() - Math.tan(this.getDirectionRadians()) * this.getStartPoint().getX();
        double otherOffset = other.getStartPoint().getY() - Math.tan(other.getDirectionRadians()) * other.getStartPoint().getX();
        double xCoord = (otherOffset - thisOffset) / (Math.tan(this.getDirectionRadians()) - Math.tan(other.getDirectionRadians()));
        return this.pointOn(new Vector2D(xCoord, yCoord = Math.tan(this.getDirectionRadians()) * xCoord + thisOffset)) && other.pointOn(new Vector2D(xCoord, yCoord));
    }

    public Vector2D getStartPoint() {
        return this.startPoint;
    }

    public Vector2D getEndPoint() {
        return this.endPoint;
    }
}

