/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import org.chsrobotics.lib.math.filters.Filter;

public class ThresholdFilter
extends Filter {
    private final double threshold;
    private final boolean invert;
    private double currentValue;

    public ThresholdFilter(double threshold, boolean invert) {
        this.threshold = threshold;
        this.invert = invert;
    }

    @Override
    public double calculate(double value) {
        this.currentValue = !this.invert ? (value <= this.threshold ? value : 0.0) : (value >= this.threshold ? value : 0.0);
        return this.currentValue;
    }

    @Override
    public double calculate(double value, double dtSeconds) {
        return this.calculate(value);
    }

    @Override
    public void reset() {
        this.currentValue = 0.0;
    }

    @Override
    public double getCurrentOutput() {
        return this.currentValue;
    }
}

