/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import edu.wpi.first.math.MathUtil;
import org.chsrobotics.lib.math.filters.Filter;

public class RateLimiter
extends Filter {
    private final double rateLimit;
    private double lastValue = 0.0;

    public RateLimiter(double rateLimit) {
        this.rateLimit = rateLimit;
    }

    @Override
    public double calculate(double value) {
        return this.calculate(value, 0.02);
    }

    @Override
    public double calculate(double value, double dtSeconds) {
        double delta = value - this.lastValue;
        this.lastValue = this.rateLimit != 0.0 ? (this.lastValue += MathUtil.clamp((double)delta, (double)(-this.rateLimit * dtSeconds), (double)(this.rateLimit * dtSeconds))) : value;
        return this.lastValue;
    }

    @Override
    public void reset() {
        this.lastValue = 0.0;
    }

    @Override
    public double getCurrentOutput() {
        return this.lastValue;
    }
}

