/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import org.chsrobotics.lib.math.UtilityMath;
import org.chsrobotics.lib.math.filters.Filter;
import org.chsrobotics.lib.util.SizedStack;

public class MovingAverageFilter
extends Filter {
    private final SizedStack<Double> stack;
    private double currentOutput = 0.0;
    private final MEAN_IMPLEMENTATION impl;

    public MovingAverageFilter(int window, MEAN_IMPLEMENTATION impl) {
        this.stack = new SizedStack(window);
        this.impl = impl;
    }

    @Override
    public double calculate(double value) {
        this.stack.push(value);
        double[] asArray = new double[this.stack.size()];
        for (int i = 0; i < this.stack.size(); ++i) {
            asArray[i] = (Double)this.stack.get(i);
        }
        this.currentOutput = this.impl == MEAN_IMPLEMENTATION.GEOMETRIC ? UtilityMath.geometricMean(asArray) : (this.impl == MEAN_IMPLEMENTATION.HARMONIC ? UtilityMath.harmonicMean(asArray) : UtilityMath.arithmeticMean(asArray));
        return this.currentOutput;
    }

    @Override
    public double calculate(double value, double dtSeconds) {
        return this.calculate(value);
    }

    @Override
    public void reset() {
        this.stack.clear();
    }

    @Override
    public double getCurrentOutput() {
        return this.currentOutput;
    }

    public static enum MEAN_IMPLEMENTATION {
        ARITHMETIC,
        GEOMETRIC,
        HARMONIC;

    }
}

