/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import java.util.Iterator;
import org.chsrobotics.lib.math.filters.Filter;
import org.chsrobotics.lib.util.SizedStack;

public class IntegratingFilter
extends Filter {
    private final SizedStack<Double> stack;
    private double currentOutput = 0.0;

    public IntegratingFilter(int window) {
        this.stack = new SizedStack(window);
    }

    @Override
    public double calculate(double value) {
        return this.calculate(value, 0.02);
    }

    @Override
    public double calculate(double value, double dt) {
        this.stack.push(value * dt);
        double sum = 0.0;
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            double entry = (Double)iterator.next();
            sum += entry;
        }
        this.currentOutput = sum;
        return sum;
    }

    @Override
    public void reset() {
        this.stack.clear();
    }

    @Override
    public double getCurrentOutput() {
        return this.currentOutput;
    }
}

