/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

public abstract class Filter {
    public abstract double calculate(double var1);

    public abstract double calculate(double var1, double var3);

    public abstract void reset();

    public abstract double getCurrentOutput();

    public static final Filter add(Filter filterA, final Filter filterB) {
        class AddedFilter
        extends Filter {
            AddedFilter() {
            }

            @Override
            public double calculate(double value) {
                return Filter.this.calculate(value) + filterB.calculate(value);
            }

            @Override
            public double calculate(double value, double dtSeconds) {
                return Filter.this.calculate(value, dtSeconds) + filterB.calculate(value, dtSeconds);
            }

            @Override
            public void reset() {
                Filter.this.reset();
                filterB.reset();
            }

            @Override
            public double getCurrentOutput() {
                return Filter.this.getCurrentOutput() + filterB.getCurrentOutput();
            }
        }
        return filterA.new AddedFilter();
    }

    public static Filter scalarMultiply(Filter filter, final double scalar) {
        class MultipliedFilter
        extends Filter {
            MultipliedFilter() {
            }

            @Override
            public double calculate(double value) {
                return Filter.this.calculate(value) * scalar;
            }

            @Override
            public double calculate(double value, double dtSeconds) {
                return Filter.this.calculate(value, dtSeconds) * scalar;
            }

            @Override
            public void reset() {
                Filter.this.reset();
            }

            @Override
            public double getCurrentOutput() {
                return Filter.this.getCurrentOutput() * scalar;
            }
        }
        return filter.new MultipliedFilter();
    }
}

