/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import org.chsrobotics.lib.math.filters.Filter;

public class DifferentiatingFilter
extends Filter {
    private final double defaultRobotPeriodSeconds = 0.02;
    private double lastValue = 0.0;
    private double currentDeriv = 0.0;

    @Override
    public double calculate(double value, double dtSeconds) {
        if (dtSeconds == 0.0) {
            return 0.0;
        }
        this.currentDeriv = (value - this.lastValue) / dtSeconds;
        this.lastValue = value;
        return this.currentDeriv;
    }

    @Override
    public double calculate(double value) {
        return this.calculate(value, 0.02);
    }

    @Override
    public void reset() {
        this.lastValue = 0.0;
        this.currentDeriv = 0.0;
    }

    @Override
    public double getCurrentOutput() {
        return this.currentDeriv;
    }
}

