/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math;

import org.chsrobotics.lib.math.geometry.Vector3D;
import org.chsrobotics.lib.util.Tuple2;

public class UtilityMath {
    public static final double defaultProportionEpsilon = 0.001;
    public static final double defaultAbsoluteEpsilon = 1.0E-5;

    public static double normalizeAngleRadians(double angleRadians) {
        return (angleRadians % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double normalizeAngleDegrees(double angleDegrees) {
        return (angleDegrees % 360.0 + 360.0) % 360.0;
    }

    public static double smallestAngleRadiansBetween(double angleA, double angleB) {
        double normA = UtilityMath.normalizeAngleRadians(angleA);
        double normB = UtilityMath.normalizeAngleRadians(angleB);
        double diff = (normB - normA + Math.PI) % (Math.PI * 2) - Math.PI;
        return diff < -Math.PI ? diff + Math.PI * 2 : diff;
    }

    public static double smallestAngleDegreesBetween(double angleA, double angleB) {
        double normA = UtilityMath.normalizeAngleDegrees(angleA);
        double normB = UtilityMath.normalizeAngleDegrees(angleB);
        double diff = (normB - normA + 180.0) % 360.0 - 180.0;
        return diff < -180.0 ? diff + 360.0 : diff;
    }

    public static Vector3D linearInterpolation(Vector3D startpoint, Vector3D endpoint, double reference) {
        return new Vector3D(startpoint.getX() + (endpoint.getX() - startpoint.getX()) * reference, startpoint.getY() + (endpoint.getY() - startpoint.getY()) * reference, startpoint.getZ() + (endpoint.getZ() - startpoint.getZ()) * reference);
    }

    public static double[] scaleToSum(double[] inputs, double desiredSum) {
        if (inputs.length == 0) {
            return inputs;
        }
        if (desiredSum == 0.0) {
            return new double[inputs.length];
        }
        double sum = 0.0;
        for (double value : inputs) {
            sum += value;
        }
        if (sum == 0.0) {
            return inputs;
        }
        double[] outputs = new double[inputs.length];
        double scalingFactor = desiredSum / sum;
        for (int i = 0; i < inputs.length; ++i) {
            outputs[i] = inputs[i] * scalingFactor;
        }
        return outputs;
    }

    public static double[] normalizeSet(double[] inputs, double maxAbsoluteValue) {
        if (inputs.length == 0) {
            return inputs;
        }
        int highestIndex = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (!(Math.abs(inputs[highestIndex]) < Math.abs(inputs[i]))) continue;
            highestIndex = i;
        }
        if (Math.abs(inputs[highestIndex]) <= maxAbsoluteValue) {
            return inputs;
        }
        double[] outputs = new double[inputs.length];
        double scalingFactor = maxAbsoluteValue / Math.abs(inputs[highestIndex]);
        for (int i = 0; i < inputs.length; ++i) {
            outputs[i] = inputs[i] * scalingFactor;
        }
        return outputs;
    }

    public static double clamp(double ceiling, double floor, double value) {
        if (value > ceiling) {
            return ceiling;
        }
        if (value < floor) {
            return floor;
        }
        return value;
    }

    public static double clamp(double maxValueAbs, double value) {
        return UtilityMath.clamp(Math.abs(maxValueAbs), -Math.abs(maxValueAbs), value);
    }

    public static Tuple2<Double> quadraticZeros(double coeffA, double coeffB, double coeffC) {
        double sqrtSafety = coeffB * coeffB - 4.0 * coeffA * coeffC;
        if (sqrtSafety < 0.0) {
            return Tuple2.of(Double.NaN, Double.NaN);
        }
        double pos = (-coeffB + Math.pow(sqrtSafety, 0.5)) / (2.0 * coeffA);
        double neg = (-coeffB - Math.pow(sqrtSafety, 0.5)) / (2.0 * coeffA);
        return Tuple2.of(pos, neg);
    }

    public static boolean epsilonEqualsAbsolute(double valueA, double valueB, double absoluteEpsilon) {
        return Math.abs(valueA - valueB) <= absoluteEpsilon;
    }

    public static boolean epsilonEqualsAbsolute(double valueA, double valueB) {
        return UtilityMath.epsilonEqualsAbsolute(valueA, valueB, 1.0E-5);
    }

    public static boolean epsilonEqualsProportion(double valueA, double valueB, double proportionEpsilon) {
        if (valueA == 0.0 && valueB == 0.0) {
            return true;
        }
        if (valueA == 0.0 || valueB == 0.0) {
            return false;
        }
        return Math.abs(valueA / valueB - 1.0) <= proportionEpsilon;
    }

    public static boolean epsilonEqualsProportion(double valueA, double valueB) {
        return UtilityMath.epsilonEqualsProportion(valueA, valueB, 0.001);
    }

    public static double hypotenuse(double legLengthA, double legLengthB) {
        return Math.pow(legLengthA * legLengthA + legLengthB * legLengthB, 0.5);
    }

    public static double leg(double hypotenuse, double legLengthA) {
        return Math.pow(hypotenuse * hypotenuse - legLengthA * legLengthA, 0.5);
    }

    public static double root(double value, int order) {
        if (order == 0) {
            return Double.NaN;
        }
        return Math.pow(value, 1.0 / (double)order);
    }

    public static double csc(double thetaRadians) {
        if (Math.sin(thetaRadians) == 0.0) {
            return Double.NaN;
        }
        return 1.0 / Math.sin(thetaRadians);
    }

    public static double sec(double thetaRadians) {
        if (Math.cos(thetaRadians) == 0.0) {
            return Double.NaN;
        }
        return 1.0 / Math.cos(thetaRadians);
    }

    public static double cot(double thetaRadians) {
        if (Math.sin(thetaRadians) == 0.0) {
            return Double.NaN;
        }
        return Math.cos(thetaRadians) / Math.sin(thetaRadians);
    }

    public static double acsc(double ratio) {
        if (ratio == 0.0) {
            return Double.NaN;
        }
        return Math.asin(1.0 / ratio);
    }

    public static double asec(double ratio) {
        if (ratio == 0.0) {
            return Double.NaN;
        }
        return Math.acos(1.0 / ratio);
    }

    public static double acot(double ratio) {
        if (ratio == 0.0) {
            return Double.NaN;
        }
        return Math.atan(1.0 / ratio);
    }

    public static double acot2(double x, double y) {
        return Math.atan2(y, x);
    }

    public static boolean inRange(double boundaryA, double boundaryB, double toCheck) {
        return boundaryA <= toCheck && toCheck <= boundaryB || boundaryA >= toCheck && toCheck >= boundaryB;
    }

    public static double arithmeticMean(double[] values) {
        if (values.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        for (double entry : values) {
            sum += entry;
        }
        return sum / (double)values.length;
    }

    public static double geometricMean(double[] values) {
        if (values.length == 0) {
            return 0.0;
        }
        double product = 1.0;
        for (double entry : values) {
            product *= entry;
        }
        return Math.pow(product, 1 / values.length);
    }

    public static double harmonicMean(double[] values) {
        double[] reciprocals = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            reciprocals[i] = values[i] == 0.0 ? 0.0 : 1.0 / values[i];
        }
        double aMean = UtilityMath.arithmeticMean(reciprocals);
        if (aMean == 0.0) {
            return 0.0;
        }
        return 1.0 / aMean;
    }
}

