/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;
import org.chsrobotics.lib.input.JoystickAxis;
import org.chsrobotics.lib.math.filters.RateLimiter;

public class CurvatureDrive
implements DifferentialDriveMode {
    private final JoystickAxis linearAxis;
    private final JoystickAxis rotationalAxis;
    private final double turnModifier;
    private final double driveModifier;
    private final RateLimiter driveLimiter;
    private final RateLimiter turnLimiter;
    private final boolean invertReverseTurning;

    public CurvatureDrive(JoystickAxis linearAxis, JoystickAxis rotationalAxis, double driveModifier, double turnModifier, double driveLimiter, double turnLimiter, boolean invertReverseTurning) {
        this.linearAxis = linearAxis;
        this.rotationalAxis = rotationalAxis;
        this.driveModifier = driveModifier;
        this.turnModifier = turnModifier;
        this.driveLimiter = new RateLimiter(driveLimiter);
        this.turnLimiter = new RateLimiter(turnLimiter);
        this.invertReverseTurning = invertReverseTurning;
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        double rotationMultiplier = this.invertReverseTurning ? Math.abs(this.linearAxis.getValue()) : this.linearAxis.getValue();
        double rotation = this.turnLimiter.calculate(this.rotationalAxis.getValue() * rotationMultiplier * this.turnModifier);
        double linear = this.driveLimiter.calculate(this.linearAxis.getValue() * this.driveModifier);
        double left = linear + rotation;
        double right = linear - rotation;
        return new DifferentialDrivetrainInput(left, right).clamp(1.0);
    }
}

