/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.controllers;

import edu.wpi.first.util.datalog.DataLog;
import java.util.Iterator;
import java.util.Objects;
import org.chsrobotics.lib.controllers.FeedbackController;
import org.chsrobotics.lib.math.UtilityMath;
import org.chsrobotics.lib.telemetry.IntrinsicLoggable;
import org.chsrobotics.lib.telemetry.Logger;
import org.chsrobotics.lib.util.SizedStack;

public class PID
implements FeedbackController,
IntrinsicLoggable {
    private double kP;
    private double kI;
    private double kD;
    private double lastMeasurement = 0.0;
    private double lastSetpoint = 0.0;
    private double lastPContribution = 0.0;
    private double lastIContribution = 0.0;
    private double lastDContribution = 0.0;
    private double maxAbsControlEffort = 0.0;
    private double maxAbsPContribution = 0.0;
    private double maxAbsIContribution = 0.0;
    private double maxAbsDContribution = 0.0;
    private double setpoint;
    private double velocity = 0.0;
    private double positionTolerance = 0.02;
    private double velocityTolerance = 0.02;
    private double currentValue = 0.0;
    private final SizedStack<Double> integrationStack;
    private boolean logsConstructed = false;
    private Logger<Double> pGainLogger;
    private Logger<Double> iGainLogger;
    private Logger<Double> dGainLogger;
    private Logger<Double> setpointLogger;
    private Logger<Double> measurementLogger;
    private Logger<Double> errorLogger;
    private Logger<Double> integralAccumulationLogger;
    private Logger<Double> errorVelocityLogger;
    private Logger<Double> totalControlEffortLogger;
    private Logger<Double> pControlEffortLogger;
    private Logger<Double> iControlEffortLogger;
    private Logger<Double> dControlEffortLogger;
    private Logger<Double> maxAbsControlEffortLogger;
    private Logger<Double> maxAbsPContributionLogger;
    private Logger<Double> maxAbsIContributionLogger;
    private Logger<Double> maxAbsDContributionLogger;
    private Logger<Boolean> atSetpointLogger;
    private Logger<Double> setpointPositionToleranceLogger;
    private Logger<Double> setpointVelocityToleranceLogger;

    public PID(double kP, double kI, double kD, int integrationWindow, double initialSetpoint) {
        this.kP = kP;
        this.kI = kI;
        this.kD = kD;
        this.integrationStack = new SizedStack(integrationWindow);
        this.setpoint = initialSetpoint;
        this.lastSetpoint = initialSetpoint;
    }

    public PID(PIDConstants constants, int integrationWindow, double initialSetpoint) {
        this(constants.getkP(), constants.getkI(), constants.getkD(), integrationWindow, initialSetpoint);
    }

    public PID(double kP, double kI, double kD, double initialSetpoint) {
        this(kP, kI, kD, 0, initialSetpoint);
    }

    public PID(PIDConstants constants, double initialSetpoint) {
        this(constants, 0, initialSetpoint);
    }

    @Override
    public void autoGenerateLogs(DataLog log, String name, String subdirName, boolean publishToNT, boolean recordInLog) {
        if (!this.logsConstructed) {
            Logger.LoggerFactory doubleLogFactory = new Logger.LoggerFactory(log, subdirName, publishToNT, recordInLog);
            this.pGainLogger = doubleLogFactory.getLogger(name + "/pGain");
            this.iGainLogger = doubleLogFactory.getLogger(name + "/iGain");
            this.dGainLogger = doubleLogFactory.getLogger(name + "/dGain");
            this.setpointLogger = doubleLogFactory.getLogger(name + "/setpoint");
            this.measurementLogger = doubleLogFactory.getLogger(name + "/measurement");
            this.errorLogger = doubleLogFactory.getLogger(name + "/error");
            this.integralAccumulationLogger = doubleLogFactory.getLogger(name + "/integralAccumulation");
            this.errorVelocityLogger = doubleLogFactory.getLogger(name + "/errorVelocity");
            this.totalControlEffortLogger = doubleLogFactory.getLogger(name + "/totalControlEffort");
            this.pControlEffortLogger = doubleLogFactory.getLogger(name + "/pControlEffort");
            this.iControlEffortLogger = doubleLogFactory.getLogger(name + "/iControlEffort");
            this.dControlEffortLogger = doubleLogFactory.getLogger(name + "/dControlEffort");
            this.maxAbsControlEffortLogger = doubleLogFactory.getLogger(name + "/maxAbsControlEffort");
            this.maxAbsPContributionLogger = doubleLogFactory.getLogger(name + "/maxAbsPControlEffort");
            this.maxAbsIContributionLogger = doubleLogFactory.getLogger(name + "/maxAbsIControlEffort");
            this.maxAbsDContributionLogger = doubleLogFactory.getLogger(name + "/maxAbsDControlEffort");
            this.atSetpointLogger = new Logger(log, name + "/atSetpoint", subdirName, publishToNT, recordInLog);
            this.setpointPositionToleranceLogger = doubleLogFactory.getLogger(name + "/setpointPositionTolerance");
            this.setpointVelocityToleranceLogger = doubleLogFactory.getLogger(name + "/setpointVelocityTolerance");
            this.logsConstructed = true;
        }
    }

    public void setConstants(double kP, double kI, double kD) {
        this.kP = kP;
        this.kI = kI;
        this.kD = kD;
    }

    public void setConstants(PIDConstants constants) {
        this.kP = constants.getkP();
        this.kI = constants.getkI();
        this.kD = constants.getkD();
    }

    public PIDConstants getConstants() {
        return new PIDConstants(this.kP, this.kI, this.kD);
    }

    public double getkP() {
        return this.kP;
    }

    public void setkP(double kP) {
        this.kP = kP;
    }

    public double getkI() {
        return this.kI;
    }

    public void setkI(double kI) {
        this.kI = kI;
    }

    public double getkD() {
        return this.kD;
    }

    public void setkD(double kD) {
        this.kD = kD;
    }

    @Override
    public void setSetpoint(double value) {
        this.setpoint = value;
    }

    @Override
    public double getSetpoint() {
        return this.setpoint;
    }

    public double getIntegralAccumulation() {
        double integrationSum = 0.0;
        Iterator iterator = this.integrationStack.iterator();
        while (iterator.hasNext()) {
            double entry = (Double)iterator.next();
            integrationSum += entry;
        }
        return integrationSum;
    }

    public void resetIntegralAccumulation() {
        this.integrationStack.clear();
    }

    public void resetPreviousMeasurement() {
        this.lastMeasurement = 0.0;
        this.lastSetpoint = this.setpoint;
    }

    @Override
    public void reset() {
        this.resetIntegralAccumulation();
        this.resetPreviousMeasurement();
    }

    @Override
    public void setSetpointTolerance(double positionTolerance, double velocityTolerance) {
        this.positionTolerance = positionTolerance;
        this.velocityTolerance = velocityTolerance;
    }

    public double getSetpointPositionTolerance() {
        return this.positionTolerance;
    }

    public double getSetpointVelocityTolerance() {
        return this.velocityTolerance;
    }

    @Override
    public double calculate(double measurement, double dt) {
        this.integrationStack.push(dt * (this.setpoint - measurement));
        this.velocity = dt == 0.0 ? 0.0 : (this.setpoint - measurement - (this.lastSetpoint - this.lastMeasurement)) / dt;
        double integrationSum = 0.0;
        Iterator iterator = this.integrationStack.iterator();
        while (iterator.hasNext()) {
            double entry = (Double)iterator.next();
            integrationSum += entry;
        }
        double rawP = this.kP * (this.setpoint - measurement);
        double rawI = this.kI * integrationSum;
        double rawD = this.kD * this.velocity;
        this.lastPContribution = Math.abs(this.maxAbsPContribution) == 0.0 ? rawP : UtilityMath.clamp(this.maxAbsPContribution, rawP);
        this.lastIContribution = Math.abs(this.maxAbsIContribution) == 0.0 ? rawI : UtilityMath.clamp(this.maxAbsIContribution, rawI);
        this.lastDContribution = Math.abs(this.maxAbsDContribution) == 0.0 ? rawD : UtilityMath.clamp(this.maxAbsDContribution, rawD);
        this.lastMeasurement = measurement;
        this.lastSetpoint = this.setpoint;
        double effortsSum = this.lastPContribution + this.lastIContribution + this.lastDContribution;
        this.currentValue = Math.abs(this.maxAbsControlEffort) == 0.0 ? effortsSum : UtilityMath.clamp(this.maxAbsControlEffort, effortsSum);
        return this.currentValue;
    }

    @Override
    public void updateLogs() {
        if (this.logsConstructed) {
            this.pGainLogger.update(this.getkP());
            this.iGainLogger.update(this.getkI());
            this.dGainLogger.update(this.getkD());
            this.setpointLogger.update(this.lastSetpoint);
            this.measurementLogger.update(this.lastMeasurement);
            this.errorLogger.update(this.lastSetpoint - this.lastMeasurement);
            this.integralAccumulationLogger.update(this.getIntegralAccumulation());
            this.errorVelocityLogger.update(this.velocity);
            this.totalControlEffortLogger.update(this.currentValue);
            this.pControlEffortLogger.update(this.getPContribution());
            this.iControlEffortLogger.update(this.getIContribution());
            this.dControlEffortLogger.update(this.getDContribution());
            this.maxAbsControlEffortLogger.update(this.maxAbsControlEffort);
            this.maxAbsPContributionLogger.update(this.maxAbsPContribution);
            this.maxAbsIContributionLogger.update(this.maxAbsIContribution);
            this.maxAbsDContributionLogger.update(this.maxAbsDContribution);
            this.atSetpointLogger.update(this.atSetpoint());
            this.setpointPositionToleranceLogger.update(this.positionTolerance);
            this.setpointVelocityToleranceLogger.update(this.velocityTolerance);
        }
    }

    @Override
    public double getCurrentValue() {
        return this.currentValue;
    }

    public double getPContribution() {
        return this.lastPContribution;
    }

    public double getIContribution() {
        return this.lastIContribution;
    }

    public double getDContribution() {
        return this.lastDContribution;
    }

    public void setMaxAbsControlEffort(double newValue) {
        this.maxAbsControlEffort = newValue;
    }

    public void setMaxAbsPContribution(double newValue) {
        this.maxAbsPContribution = Math.abs(newValue);
    }

    public void setMaxAbsIContribution(double newValue) {
        this.maxAbsIContribution = Math.abs(newValue);
    }

    public void setMaxDContribution(double newValue) {
        this.maxAbsDContribution = Math.abs(newValue);
    }

    public double getMaxAbsControlEffort() {
        return this.maxAbsControlEffort;
    }

    public double getMaxAbsPContribution() {
        return this.maxAbsPContribution;
    }

    public double getMaxAbsIContribution() {
        return this.maxAbsIContribution;
    }

    public double getMaxAbsDContribution() {
        return this.maxAbsDContribution;
    }

    @Override
    public double calculate(double measurement) {
        return this.calculate(measurement, 0.02);
    }

    @Override
    public boolean atSetpoint() {
        return Math.abs(this.setpoint - this.lastMeasurement) < Math.abs(this.positionTolerance * this.setpoint) && Math.abs(this.velocity) < Math.abs(this.velocityTolerance * this.setpoint);
    }

    public static class PIDConstants {
        private final double kP;
        private final double kI;
        private final double kD;

        public PIDConstants(double kP, double kI, double kD) {
            this.kP = kP;
            this.kI = kI;
            this.kD = kD;
        }

        public double getkP() {
            return this.kP;
        }

        public double getkI() {
            return this.kI;
        }

        public double getkD() {
            return this.kD;
        }

        public boolean equals(Object other) {
            double epsilon = 1.0E-4;
            if (other instanceof PIDConstants) {
                PIDConstants rhs = (PIDConstants)other;
                return Math.abs(this.kP - rhs.kP) < epsilon && Math.abs(this.kI - rhs.kI) < epsilon && Math.abs(this.kD - rhs.kD) < epsilon;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.kP, this.kI, this.kD);
        }

        public String toString() {
            return "PIDConstants: " + this.kP + ", " + this.kI + ", " + this.kD;
        }
    }
}

