/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.chsrobotics.lib.controllers.FeedbackController;
import org.chsrobotics.lib.math.filters.Filter;

public class ComposedFeedbackController
implements FeedbackController {
    private final List<Filter> filters;
    private double setpoint = 0.0;
    private double currentValue = 0.0;
    private double velocity = 0.0;
    private double lastMeasurement = 0.0;
    private double lastSetpoint = 0.0;
    private double positionTolerance = 0.02;
    private double velocityTolerance = 0.02;

    public ComposedFeedbackController(List<Filter> filters) {
        this.filters = filters;
    }

    public ComposedFeedbackController(Map<Filter, Double> values) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Filter filter : values.keySet()) {
            filters.add(Filter.scalarMultiply(filter, values.get(filter)));
        }
        this.filters = filters;
    }

    @Override
    public void reset() {
        for (Filter filter : this.filters) {
            filter.reset();
        }
    }

    @Override
    public void setSetpoint(double value) {
        this.setpoint = value;
    }

    @Override
    public double getSetpoint() {
        return this.setpoint;
    }

    @Override
    public double calculate(double measurement) {
        return this.calculate(measurement, 0.02);
    }

    @Override
    public double calculate(double measurement, double dtSeconds) {
        double error = this.setpoint - measurement;
        this.currentValue = 0.0;
        this.velocity = dtSeconds == 0.0 ? 0.0 : (this.setpoint - measurement - (this.lastSetpoint - this.lastMeasurement)) / dtSeconds;
        for (Filter filter : this.filters) {
            this.currentValue += filter.calculate(error, dtSeconds);
        }
        this.lastMeasurement = measurement;
        this.lastSetpoint = this.setpoint;
        return this.currentValue;
    }

    @Override
    public double getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public void setSetpointTolerance(double positionErrorProportion, double velocityErrorProportion) {
        this.positionTolerance = positionErrorProportion;
        this.velocityTolerance = velocityErrorProportion;
    }

    @Override
    public boolean atSetpoint() {
        return Math.abs(this.setpoint - this.lastMeasurement) < Math.abs(this.positionTolerance * this.setpoint) && Math.abs(this.velocity) < Math.abs(this.velocityTolerance * this.setpoint);
    }
}

