/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.commands;

import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj2.command.CommandBase;
import edu.wpi.first.wpilibj2.command.Subsystem;
import java.util.function.Supplier;

public class ConditionalRunnableCommand
extends CommandBase {
    private final Timer timer = new Timer();
    private final Supplier<Boolean> conditional;
    private final Runnable onTrue;
    private final Runnable onFalse;
    private final double durationSeconds;
    private boolean lastConditionalValue;
    private boolean runsWhileDisabled = false;

    public ConditionalRunnableCommand(Runnable onTrue, Runnable onFalse, Supplier<Boolean> conditional, double durationSeconds, Subsystem ... toRequire) {
        this.conditional = conditional;
        this.onTrue = onTrue;
        this.onFalse = onFalse;
        this.durationSeconds = durationSeconds;
        this.lastConditionalValue = conditional.get();
        this.addRequirements(toRequire);
    }

    public ConditionalRunnableCommand(Runnable onTrue, Runnable onFalse, Supplier<Boolean> conditional, Subsystem ... toRequire) {
        this(onTrue, onFalse, conditional, -1.0, toRequire);
    }

    public void setRunsWhileDisabled(boolean runsWhileDisabled) {
        this.runsWhileDisabled = runsWhileDisabled;
    }

    public boolean runsWhenDisabled() {
        return this.runsWhileDisabled;
    }

    public void initialize() {
        this.timer.reset();
        this.timer.start();
    }

    public void execute() {
        boolean value = this.conditional.get();
        if (!this.lastConditionalValue && value && this.onTrue != null) {
            this.onTrue.run();
        } else if (this.lastConditionalValue && !value && this.onFalse != null) {
            this.onFalse.run();
        }
        this.lastConditionalValue = value;
    }

    public boolean isFinished() {
        return this.durationSeconds >= 0.0 && this.timer.get() >= this.durationSeconds;
    }
}

