/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory;

import java.util.Objects;
import org.chsrobotics.lib.trajectory.AsymmetricTrapezoidProfile;
import org.chsrobotics.lib.trajectory.MotionProfile;

public class TrapezoidProfile
extends AsymmetricTrapezoidProfile {
    public TrapezoidProfile(Constraints constraints, MotionProfile.State goalState, MotionProfile.State initialState) {
        super(new AsymmetricTrapezoidProfile.Constraints(constraints.maxVelocity, constraints.maxAcceleration, constraints.maxAcceleration), goalState, initialState);
    }

    public TrapezoidProfile(Constraints constraints, MotionProfile.State goalState) {
        super(new AsymmetricTrapezoidProfile.Constraints(constraints.maxVelocity, constraints.maxAcceleration, constraints.maxAcceleration), goalState);
    }

    public static class Constraints {
        public final double maxVelocity;
        public final double maxAcceleration;

        public Constraints(double maxVelocity, double maxAcceleration) {
            this.maxVelocity = maxVelocity;
            this.maxAcceleration = maxAcceleration;
        }

        public boolean equals(Object other) {
            double epsilon = 1.0E-4;
            if (other instanceof Constraints) {
                Constraints rhs = (Constraints)other;
                return Math.abs(this.maxVelocity - rhs.maxVelocity) < epsilon && Math.abs(this.maxAcceleration - rhs.maxAcceleration) < epsilon;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.maxVelocity, this.maxAcceleration);
        }

        public String toString() {
            return "TrapezoidProfileConstraints[maxVelocity: " + this.maxVelocity + ", maxAcceleration: " + this.maxAcceleration + "]";
        }
    }
}

