/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.trajectory;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.chsrobotics.lib.trajectory.ProfilePhase;

public class MotionProfile {
    protected List<ProfilePhase> phases = new ArrayList<ProfilePhase>();
    protected State initialState;

    public MotionProfile(State initialState, ProfilePhase ... phases) {
        this.initialState = initialState;
        for (ProfilePhase phase : phases) {
            this.phases.add(phase);
        }
    }

    protected MotionProfile(State initialState) {
        this.initialState = initialState;
    }

    public MotionProfile(ProfilePhase ... phases) {
        this(new State(0.0, 0.0), phases);
    }

    public List<ProfilePhase> getPhases() {
        return List.copyOf(this.phases);
    }

    public double totalTime() {
        double time = 0.0;
        for (ProfilePhase phase : this.phases) {
            time += phase.time;
        }
        return time;
    }

    public boolean isFinished(double time) {
        return time >= this.totalTime();
    }

    public State calculate(double time) {
        if (time <= 0.0) {
            return this.initialState;
        }
        double position = this.initialState.position;
        for (ProfilePhase phase : this.phases) {
            if (time - phase.time < 0.0) {
                return new State(position + 0.5 * phase.acceleration * Math.pow(time, 2.0) + phase.initialVelocity * time, time * phase.acceleration + phase.initialVelocity);
            }
            time -= phase.time;
            position += phase.position;
        }
        return new State(position, 0.0);
    }

    public static class State {
        public final double position;
        public final double velocity;

        public State(double position, double velocity) {
            this.position = position;
            this.velocity = velocity;
        }

        public boolean equals(Object other) {
            double epsilon = 1.0E-4;
            if (other instanceof State) {
                State rhs = (State)other;
                return Math.abs(this.position - rhs.position) < epsilon && Math.abs(this.velocity - rhs.velocity) < epsilon;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.position, this.velocity);
        }

        public String toString() {
            return "State[position: " + this.position + ", velocity: " + this.velocity + ", time: ";
        }
    }
}

