/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.telemetry;

import edu.wpi.first.networktables.NetworkTableEntry;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.util.datalog.BooleanArrayLogEntry;
import edu.wpi.first.util.datalog.BooleanLogEntry;
import edu.wpi.first.util.datalog.DataLog;
import edu.wpi.first.util.datalog.DoubleArrayLogEntry;
import edu.wpi.first.util.datalog.DoubleLogEntry;
import edu.wpi.first.util.datalog.StringArrayLogEntry;
import edu.wpi.first.util.datalog.StringLogEntry;
import java.util.Arrays;
import java.util.List;
import org.chsrobotics.lib.telemetry.HighLevelLogger;

public class Logger<T> {
    private final DataLog log;
    private boolean publishToNT;
    private boolean recordInLog;
    private final String logEntryIdentifier;
    private BooleanLogEntry boolLogEntry;
    private DoubleLogEntry doubleLogEntry;
    private StringLogEntry stringLogEntry;
    private BooleanArrayLogEntry boolArrayLogEntry;
    private DoubleArrayLogEntry doubleArrayLogEntry;
    private StringArrayLogEntry stringArrayLogEntry;
    private final NetworkTableEntry ntEntry;
    private boolean logEntryExists = false;
    private T previousValue = null;

    public Logger(DataLog log, String key, String subdirName, boolean publishToNT, boolean recordInLog) {
        this.log = log;
        this.publishToNT = publishToNT;
        this.recordInLog = recordInLog;
        this.logEntryIdentifier = subdirName + "_" + key;
        this.ntEntry = NetworkTableInstance.getDefault().getTable(subdirName).getEntry(key);
    }

    public Logger(String key, String subdirName) {
        this(HighLevelLogger.getLog(), key, subdirName, true, true);
    }

    public boolean isPublishingToNT() {
        return this.publishToNT;
    }

    public void startPublishingToDashboard() {
        this.publishToNT = true;
    }

    public void stopPublishingToDashboard() {
        this.publishToNT = false;
    }

    public boolean isRecordingToLog() {
        return this.recordInLog;
    }

    public void startRecordingToLog() {
        this.recordInLog = true;
    }

    public void stopRecordingToLog() {
        this.recordInLog = false;
    }

    public void update(T value) {
        if (value instanceof Number) {
            if (!this.logEntryExists) {
                this.doubleLogEntry = new DoubleLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.doubleLogEntry.append(((Number)value).doubleValue());
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetDouble(((Number)value).doubleValue());
            }
        } else if (value instanceof Number[]) {
            List<Number> list = Arrays.asList((Number[])value);
            double[] castArray = list.stream().mapToDouble(Number::doubleValue).toArray();
            if (!this.logEntryExists) {
                this.doubleArrayLogEntry = new DoubleArrayLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.doubleArrayLogEntry.append(castArray);
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetDoubleArray(castArray);
            }
        } else if (value instanceof Boolean) {
            if (!this.logEntryExists) {
                this.boolLogEntry = new BooleanLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.boolLogEntry.append(((Boolean)value).booleanValue());
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetBoolean(((Boolean)value).booleanValue());
            }
        } else if (value instanceof Boolean[]) {
            if (!this.logEntryExists) {
                this.boolArrayLogEntry = new BooleanArrayLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.boolArrayLogEntry.append((boolean[])value);
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetBooleanArray((boolean[])value);
            }
        } else if (value instanceof String) {
            if (!this.logEntryExists) {
                this.stringLogEntry = new StringLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.stringLogEntry.append((String)value);
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetString((String)value);
            }
        } else if (value instanceof String[]) {
            if (!this.logEntryExists) {
                this.stringArrayLogEntry = new StringArrayLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.stringArrayLogEntry.append((String[])value);
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetStringArray((String[])value);
            }
        } else {
            if (!this.logEntryExists) {
                this.stringLogEntry = new StringLogEntry(this.log, this.logEntryIdentifier);
                this.logEntryExists = true;
            }
            if (this.recordInLog && !value.equals(this.previousValue)) {
                this.stringLogEntry.append(value.toString());
            }
            if (this.publishToNT && !value.equals(this.previousValue)) {
                this.ntEntry.forceSetString(value.toString());
            }
        }
        this.previousValue = value;
    }
}

