/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.telemetry;

import edu.wpi.first.networktables.NetworkTable;
import edu.wpi.first.networktables.NetworkTableInstance;
import edu.wpi.first.util.datalog.DataLog;
import edu.wpi.first.util.sendable.Sendable;
import edu.wpi.first.util.sendable.SendableBuilder;
import edu.wpi.first.util.sendable.SendableRegistry;
import edu.wpi.first.wpilibj.DataLogManager;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Filesystem;
import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.RobotController;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.smartdashboard.SendableBuilderImpl;
import edu.wpi.first.wpilibj2.command.Command;
import edu.wpi.first.wpilibj2.command.CommandScheduler;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.chsrobotics.lib.telemetry.Logger;

public class HighLevelLogger {
    private static boolean hasStarted = false;
    private static final String commitDataFilename = "commit.txt";
    private static final String branchDataFilename = "branch.txt";
    private static HashMap<Command, Timer> commandTimeMap = new HashMap();
    private static final Logger<String[]> scheduledCommandsLogger = new Logger("scheduledCommands", "commandScheduler");
    private static final String subdirString = "System";
    private static final Logger<Boolean> isBrownedOutLogger = new Logger("isBrownedOut", "System");
    private static final Logger<Double> canUtilizationLogger = new Logger("canUtilizationPercent", "System");
    private static final Logger<Double> batteryVoltageLogger = new Logger("batteryVoltageVolts", "System");
    private static final Logger<Double> logger3p3vCurrent = new Logger("3p3vCurrentAmps", "System");
    private static final Logger<Double> logger5vCurrent = new Logger("5vCurrentAmps", "System");
    private static final Logger<Integer> brownoutCounterLogger = new Logger("brownoutCounter", "System");
    private static int brownoutCounter = 0;
    private static final NetworkTable sendables = NetworkTableInstance.getDefault().getTable("sendables");
    private static final Map<String, Sendable> tablesToData = new HashMap<String, Sendable>();

    public static void startLogging() {
        if (!hasStarted) {
            CommandScheduler.getInstance().onCommandInitialize(HighLevelLogger::logCommandInit);
            CommandScheduler.getInstance().onCommandFinish(HighLevelLogger::logCommandFinished);
            CommandScheduler.getInstance().onCommandInterrupt(HighLevelLogger::logCommandInterrupted);
            hasStarted = true;
            DataLogManager.logNetworkTables((boolean)false);
            HighLevelLogger.logMessage("Log init");
            HighLevelLogger.logMessage("Real time: " + LocalDateTime.now().toString());
            HighLevelLogger.logMessage("Robot is: " + (RobotBase.isReal() ? "real" : "simulated"));
            HighLevelLogger.logMessage("Event: " + (DriverStation.isFMSAttached() ? DriverStation.getEventName() : "N/A"));
            HighLevelLogger.logMessage("Match type: " + (DriverStation.isFMSAttached() ? DriverStation.getMatchType().toString() : "N/A"));
            HighLevelLogger.logMessage("Match number: " + (Serializable)(DriverStation.isFMSAttached() ? Integer.valueOf(DriverStation.getMatchNumber()) : "N/A"));
            try {
                File commitTxt = new File(Filesystem.getDeployDirectory(), commitDataFilename);
                File branchTxt = new File(Filesystem.getDeployDirectory(), branchDataFilename);
                HighLevelLogger.logMessage("Git commit: " + Files.readString(commitTxt.toPath()));
                HighLevelLogger.logMessage("Git branch: " + Files.readString(branchTxt.toPath()));
            }
            catch (IOException exc) {
                HighLevelLogger.logMessage("Git branch / commit data could not be read!");
            }
        }
    }

    public static void logPeriodic() {
        ArrayList<String> commands = new ArrayList<String>();
        for (Command command : commandTimeMap.keySet()) {
            commands.add(command.getName());
        }
        scheduledCommandsLogger.update(commands.toArray(new String[0]));
        if (RobotController.getBatteryVoltage() < RobotController.getBrownoutVoltage()) {
            ++brownoutCounter;
            isBrownedOutLogger.update(true);
        } else {
            isBrownedOutLogger.update(false);
        }
        brownoutCounterLogger.update(brownoutCounter);
        canUtilizationLogger.update(RobotController.getCANStatus().percentBusUtilization);
        batteryVoltageLogger.update(RobotController.getBatteryVoltage());
        logger3p3vCurrent.update(RobotController.getCurrent3V3());
        logger5vCurrent.update(RobotController.getCurrent5V());
    }

    public static DataLog getLog() {
        if (!hasStarted) {
            HighLevelLogger.startLogging();
        }
        return DataLogManager.getLog();
    }

    public static void logMessage(String message) {
        if (!hasStarted) {
            HighLevelLogger.startLogging();
        }
        DataLogManager.log((String)message);
    }

    public static void logWarning(String message) {
        HighLevelLogger.logMessage("WARNING " + message);
        DriverStation.reportWarning((String)message, (boolean)false);
    }

    public static void logError(String message) {
        HighLevelLogger.logMessage("ERROR " + message);
        DriverStation.reportError((String)message, (boolean)false);
    }

    public static synchronized void publishSendable(String key, Sendable data) {
        Sendable sddata = tablesToData.get(key);
        if (sddata == null || sddata != data) {
            tablesToData.put(key, data);
            NetworkTable dataTable = sendables.getSubTable(key);
            SendableBuilderImpl builder = new SendableBuilderImpl();
            builder.setTable(dataTable);
            SendableRegistry.publish((Sendable)data, (SendableBuilder)builder);
            builder.startListeners();
            dataTable.getEntry(".name").setString(key);
        }
    }

    private static void logCommandInit(Command command) {
        HighLevelLogger.logMessage("Command initialized: " + command.getName());
        Timer timer = new Timer();
        timer.reset();
        timer.start();
        commandTimeMap.put(command, timer);
    }

    private static void logCommandFinished(Command command) {
        HighLevelLogger.logMessage("Command finished after " + commandTimeMap.get(command).get() + " seconds: " + command.getName());
        commandTimeMap.remove(command);
    }

    private static void logCommandInterrupted(Command command) {
        HighLevelLogger.logMessage("Command interrupted after " + commandTimeMap.get(command).get() + " seconds: " + command.getName());
        commandTimeMap.remove(command);
    }
}

