/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import edu.wpi.first.math.MathUtil;
import org.chsrobotics.lib.math.filters.Filter;

public class RateLimiter
implements Filter {
    private final double rateLimit;
    private final double dtSeconds;
    private double lastValue = 0.0;

    public RateLimiter(double rateLimit, double dtSeconds) {
        this.rateLimit = rateLimit;
        this.dtSeconds = dtSeconds;
    }

    public RateLimiter(double rateLimit) {
        this(rateLimit, 0.02);
    }

    @Override
    public double calculate(double value) {
        double delta = value - this.lastValue;
        this.lastValue = this.rateLimit != 0.0 ? (this.lastValue += MathUtil.clamp((double)delta, (double)(-this.rateLimit * this.dtSeconds), (double)(this.rateLimit * this.dtSeconds))) : value;
        return this.lastValue;
    }

    @Override
    public void reset() {
        this.lastValue = 0.0;
    }

    @Override
    public double getCurrentOutput() {
        return this.lastValue;
    }
}

