/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import java.security.InvalidParameterException;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.chsrobotics.lib.math.filters.Filter;

public class PeakDetectionFilter
implements Filter {
    private final double threshold;
    private final double standardDeviationInfluence;
    private final double meanInfluence;
    private final double minimumDelta;
    private final DescriptiveStatistics standardDeviationSeries;
    private final DescriptiveStatistics meanSeries;
    private final DescriptiveStatistics series;
    private int returnValue = 0;

    public PeakDetectionFilter(int window, double threshold, double standardDeviationInfluence, double meanInfluence, double minimumDelta) {
        if (window < 2) {
            throw new InvalidParameterException("Window of PeakDetectionFilter must be greater than 1 for meaningful answers!");
        }
        this.threshold = threshold;
        this.standardDeviationInfluence = standardDeviationInfluence;
        this.meanInfluence = meanInfluence;
        this.minimumDelta = minimumDelta;
        this.standardDeviationSeries = new DescriptiveStatistics(window);
        this.meanSeries = new DescriptiveStatistics(window);
        this.series = new DescriptiveStatistics(window);
    }

    public PeakDetectionFilter(int window, double threshold, double standardDeviationInfluence, double meanInfluence) {
        this(window, threshold, standardDeviationInfluence, meanInfluence, 0.0);
    }

    @Override
    public double calculate(double value) {
        if ((int)this.series.getN() == 0) {
            this.standardDeviationSeries.addValue(value);
            this.meanSeries.addValue(value);
            this.series.addValue(value);
        }
        this.returnValue = (int)this.series.getN() < this.series.getWindowSize() ? 0 : (Math.abs(value - this.meanSeries.getMean()) > this.threshold * this.standardDeviationSeries.getStandardDeviation() && Math.abs(value - this.meanSeries.getMean()) >= this.minimumDelta ? (value > this.meanSeries.getMean() ? 1 : -1) : 0);
        this.meanSeries.addValue(this.meanInfluence * value + (1.0 - this.meanInfluence) * this.meanSeries.getElement((int)this.meanSeries.getN() - 1));
        this.standardDeviationSeries.addValue(this.standardDeviationInfluence * value + (1.0 - this.standardDeviationInfluence) * this.standardDeviationSeries.getElement((int)this.standardDeviationSeries.getN() - 1));
        this.series.addValue(value);
        return this.returnValue;
    }

    @Override
    public void reset() {
        this.standardDeviationSeries.clear();
        this.meanSeries.clear();
        this.series.clear();
    }

    @Override
    public double getCurrentOutput() {
        return this.returnValue;
    }
}

