/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math.filters;

import org.chsrobotics.lib.math.filters.Filter;

public class DifferentiatingFilter
implements Filter {
    private final double defaultRobotPeriodSeconds = 0.02;
    private double lastValue = 0.0;
    private double currentDeriv = 0.0;

    public double calculate(double value, double dt) {
        if (dt == 0.0) {
            return 0.0;
        }
        this.currentDeriv = (value - this.lastValue) / dt;
        this.lastValue = value;
        return this.currentDeriv;
    }

    @Override
    public double calculate(double value) {
        return this.calculate(value, 0.02);
    }

    @Override
    public void reset() {
        this.lastValue = 0.0;
        this.currentDeriv = 0.0;
    }

    @Override
    public double getCurrentOutput() {
        return this.currentDeriv;
    }
}

