/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math;

public class UtilityMath {
    public static double normalizeAngleRadians(double angleRadians) {
        return (angleRadians % (Math.PI * 2) + Math.PI * 2) % (Math.PI * 2);
    }

    public static double normalizeAngleDegrees(double angleDegrees) {
        return (angleDegrees % 360.0 + 360.0) % 360.0;
    }

    public static double smallestAngleRadiansBetween(double angleA, double angleB) {
        double normA = UtilityMath.normalizeAngleRadians(angleA);
        double normB = UtilityMath.normalizeAngleRadians(angleB);
        double diff = (normB - normA + Math.PI) % (Math.PI * 2) - Math.PI;
        return diff < -Math.PI ? diff + Math.PI * 2 : diff;
    }

    public static double smallestAngleDegreesBetween(double angleA, double angleB) {
        double normA = UtilityMath.normalizeAngleDegrees(angleA);
        double normB = UtilityMath.normalizeAngleDegrees(angleB);
        double diff = (normB - normA + 180.0) % 360.0 - 180.0;
        return diff < -180.0 ? diff + 360.0 : diff;
    }

    public static double simpleLinearInterpolation(double y0, double x0, double y1, double x1, double x) {
        return y0 + (x - x0) * (y1 - y0) / (x1 - x0);
    }

    public static double[] scaleToSum(double[] inputs, double desiredSum) {
        if (inputs.length == 0) {
            return inputs;
        }
        if (desiredSum == 0.0) {
            return new double[inputs.length];
        }
        double sum = 0.0;
        for (double value : inputs) {
            sum += value;
        }
        double[] outputs = new double[inputs.length];
        double scalingFactor = desiredSum / sum;
        for (int i = 0; i < inputs.length; ++i) {
            outputs[i] = inputs[i] * scalingFactor;
        }
        return outputs;
    }

    public static double[] normalizeSet(double[] inputs, double maxAbsoluteValue) {
        if (inputs.length == 0) {
            return inputs;
        }
        int highestIndex = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (!(Math.abs(inputs[highestIndex]) < Math.abs(inputs[i]))) continue;
            highestIndex = i;
        }
        if (Math.abs(inputs[highestIndex]) <= maxAbsoluteValue) {
            return inputs;
        }
        double[] outputs = new double[inputs.length];
        double scalingFactor = maxAbsoluteValue / Math.abs(inputs[highestIndex]);
        for (int i = 0; i < inputs.length; ++i) {
            outputs[i] = inputs[i] * scalingFactor;
        }
        return outputs;
    }
}

