/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.math;

import java.security.InvalidParameterException;
import java.util.TreeMap;
import org.chsrobotics.lib.math.UtilityMath;

public class MultiPointInterpolator {
    private final TreeMap<Double, Double> points;

    public MultiPointInterpolator(TreeMap<Double, Double> points) throws InvalidParameterException {
        if (points.isEmpty()) {
            throw new InvalidParameterException("Length of map must not be zero!");
        }
        this.points = points;
        if (!this.points.containsKey(0.0)) {
            this.points.put(0.0, 0.0);
        }
    }

    public void putNewPairs(TreeMap<Double, Double> points) {
        this.points.putAll(points);
    }

    public void putNewPair(double key, double value) {
        this.points.put(key, value);
    }

    public double sample(double key) throws InvalidParameterException {
        if (key < 0.0) {
            throw new InvalidParameterException("Place to sample must not be less than zero!");
        }
        if (this.points.containsKey(key)) {
            return this.points.get(key);
        }
        Double ceiling = this.points.ceilingKey(key);
        if (ceiling == null) {
            return 0.0;
        }
        double floor = this.points.floorKey(key);
        return UtilityMath.simpleLinearInterpolation(this.points.get(floor), floor, this.points.get(ceiling), ceiling, key);
    }
}

