/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.input;

import edu.wpi.first.wpilibj.GenericHID;
import java.util.ArrayList;
import java.util.List;
import org.chsrobotics.lib.input.JoystickAxis;
import org.chsrobotics.lib.input.JoystickButton;
import org.chsrobotics.lib.telemetry.HighLevelLogger;

public class XboxController {
    private final GenericHID controller;
    private double rightRumble = 0.0;
    private double leftRumble = 0.0;
    private final ArrayList<Boolean> axisAllocations = new ArrayList<Boolean>(List.of(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
    private final ArrayList<Boolean> buttonAllocations = new ArrayList<Boolean>(List.of(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));

    public XboxController(int port) {
        this.controller = new GenericHID(port);
    }

    public void setRightRumble(double value) {
        this.controller.setRumble(GenericHID.RumbleType.kRightRumble, value);
        this.rightRumble = value;
    }

    public void setLeftRumble(double value) {
        this.controller.setRumble(GenericHID.RumbleType.kLeftRumble, value);
        this.leftRumble = value;
    }

    public double getRightRumble() {
        return this.rightRumble;
    }

    public double getLeftRumble() {
        return this.leftRumble;
    }

    public JoystickAxis leftStickVerticalAxis() {
        if (this.axisAllocations.get(1).booleanValue()) {
            HighLevelLogger.logWarning("JoystickAxis already allocated!");
        } else {
            this.axisAllocations.set(1, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(1), "1", true);
    }

    public JoystickAxis leftStickHorizontalAxis() {
        if (this.axisAllocations.get(0).booleanValue()) {
            HighLevelLogger.logWarning("JoystickAxis already allocated!");
        } else {
            this.axisAllocations.set(0, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(0), "0", true);
    }

    public JoystickAxis rightStickVerticalAxis() {
        if (this.axisAllocations.get(5).booleanValue()) {
            HighLevelLogger.logWarning("JoystickAxis already allocated!");
        } else {
            this.axisAllocations.set(5, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(5), "5", true);
    }

    public JoystickAxis rightStickHorizontalAxis() {
        if (this.axisAllocations.get(4).booleanValue()) {
            HighLevelLogger.logWarning("JoystickAxis already allocated!");
        } else {
            this.axisAllocations.set(4, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(4), "4", true);
    }

    public JoystickAxis leftTriggerAxis() {
        if (this.axisAllocations.get(2).booleanValue()) {
            HighLevelLogger.logWarning("JoystickAxis already allocated!");
        } else {
            this.axisAllocations.set(2, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(2), "2", true);
    }

    public JoystickAxis rightTriggerAxis() {
        if (this.axisAllocations.get(3).booleanValue()) {
            HighLevelLogger.logWarning("JoystickAxis already allocated!");
        } else {
            this.axisAllocations.set(3, true);
        }
        return new JoystickAxis(() -> this.controller.getRawAxis(3), "3", true);
    }

    public JoystickButton AButton() {
        if (this.buttonAllocations.get(0).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(0, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(1), "1", true);
    }

    public JoystickButton BButton() {
        if (this.buttonAllocations.get(1).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(1, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(2), "2", true);
    }

    public JoystickButton XButton() {
        if (this.buttonAllocations.get(2).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(2, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(3), "3", true);
    }

    public JoystickButton YButton() {
        if (this.buttonAllocations.get(3).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(3, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(4), "4", true);
    }

    public JoystickButton leftBumperButton() {
        if (this.buttonAllocations.get(4).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(4, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(5), "5", true);
    }

    public JoystickButton rightBumperButton() {
        if (this.buttonAllocations.get(5).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(5, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(6), "6", true);
    }

    public JoystickButton leftStickButton() {
        if (this.buttonAllocations.get(8).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(8, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(9), "9", true);
    }

    public JoystickButton rightStickButton() {
        if (this.buttonAllocations.get(9).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(9, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(10), "10", true);
    }

    public JoystickButton backButton() {
        if (this.buttonAllocations.get(6).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(6, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(7), "7", true);
    }

    public JoystickButton startButton() {
        if (this.buttonAllocations.get(7).booleanValue()) {
            HighLevelLogger.logWarning("JoystickButton already allocated!");
        } else {
            this.buttonAllocations.set(7, true);
        }
        return new JoystickButton(() -> this.controller.getRawButton(8), "8", true);
    }
}

