/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.input;

import java.util.function.Supplier;

public class JoystickAxis {
    private final Supplier<Double> valueLambda;
    private double deadband = 0.0;
    private final String name;
    private final boolean isReal;
    private int invert = 1;

    protected JoystickAxis(Supplier<Double> valueLambda, String name, boolean isReal) {
        this.valueLambda = valueLambda;
        this.name = name;
        this.isReal = isReal;
    }

    public double getValue() {
        return Math.abs(this.valueLambda.get()) > this.deadband ? this.valueLambda.get() * (double)this.invert : 0.0;
    }

    public void addDeadband(double magnitude) {
        this.deadband = Math.abs(magnitude);
    }

    public void setInverted(boolean trueIfInverted) {
        this.invert = trueIfInverted ? -1 : 1;
    }

    public boolean isInverted() {
        return this.invert == -1;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public String toString() {
        return "JoystickAxis: " + this.name;
    }
}

