/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;
import org.chsrobotics.lib.input.JoystickAxis;
import org.chsrobotics.lib.math.filters.RateLimiter;

public class TankDrive
implements DifferentialDriveMode {
    private final JoystickAxis leftAxis;
    private final JoystickAxis rightAxis;
    private final double driveModifier;
    private RateLimiter leftDriveLimiter;
    private RateLimiter rightDriveLimiter;

    public TankDrive(JoystickAxis leftAxis, JoystickAxis rightAxis, double driveModifier, double driveLimiter) {
        this.leftAxis = leftAxis;
        this.rightAxis = rightAxis;
        this.driveModifier = driveModifier;
        this.leftDriveLimiter = new RateLimiter(driveLimiter);
        this.rightDriveLimiter = new RateLimiter(driveLimiter);
    }

    public TankDrive(JoystickAxis leftAxis, JoystickAxis rightAxis) {
        this(leftAxis, rightAxis, 0.0, 0.0);
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        double left = this.leftAxis.getValue() * this.driveModifier;
        double right = this.rightAxis.getValue() * this.driveModifier;
        left = this.leftDriveLimiter.calculate(left);
        right = this.rightDriveLimiter.calculate(right);
        return new DifferentialDrivetrainInput(left, right).clamp(1.0);
    }
}

