/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.drive.differential;

import org.chsrobotics.lib.drive.differential.DifferentialDriveMode;
import org.chsrobotics.lib.drive.differential.DifferentialDrivetrainInput;
import org.chsrobotics.lib.input.JoystickAxis;
import org.chsrobotics.lib.math.filters.RateLimiter;

public class ArcadeDrive
implements DifferentialDriveMode {
    private final JoystickAxis linearAxis;
    private final JoystickAxis rotationalAxis;
    private final double driveModifier;
    private final double turnModifier;
    private final RateLimiter driveLimiter;
    private final RateLimiter turnLimiter;

    public ArcadeDrive(JoystickAxis linearAxis, JoystickAxis rotationalAxis, double driveModifier, double turnModifier, double driveLimiter, double turnLimiter) {
        this.linearAxis = linearAxis;
        this.rotationalAxis = rotationalAxis;
        this.driveModifier = driveModifier;
        this.turnModifier = turnModifier;
        this.driveLimiter = new RateLimiter(driveLimiter);
        this.turnLimiter = new RateLimiter(turnLimiter);
    }

    @Override
    public DifferentialDrivetrainInput execute() {
        double linear = this.driveLimiter.calculate(this.linearAxis.getValue() * this.driveModifier);
        double rotation = this.turnLimiter.calculate(this.rotationalAxis.getValue() * this.turnModifier);
        double left = linear + rotation;
        double right = linear - rotation;
        return new DifferentialDrivetrainInput(left, right).clamp(1.0);
    }
}

