/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.controllers;

import java.util.Objects;

public class PID {
    private double kP;
    private double kI;
    private double kD;
    private double lastMeasurement = 0.0;
    private double lastSetpoint = 0.0;
    private double integralAccumulation = 0.0;
    private double setpoint;
    private double velocity = 0.0;
    private double positionTolerance = 0.02;
    private double velocityTolerance = 0.02;

    public PID(double kP, double kI, double kD, double initialSetpoint) {
        this.kP = kP;
        this.kI = kI;
        this.kD = kD;
        this.setpoint = initialSetpoint;
        this.lastSetpoint = initialSetpoint;
    }

    public PID(PIDConstants constants, double initialSetpoint) {
        this(constants.getkP(), constants.getkI(), constants.getkD(), initialSetpoint);
    }

    public void setConstants(double kP, double kI, double kD) {
        this.kP = kP;
        this.kI = kI;
        this.kD = kD;
    }

    public void setConstants(PIDConstants constants) {
        this.kP = constants.getkP();
        this.kI = constants.getkI();
        this.kD = constants.getkD();
    }

    public PIDConstants getConstants() {
        return new PIDConstants(this.kP, this.kI, this.kD);
    }

    public double getkP() {
        return this.kP;
    }

    public void setkP(double kP) {
        this.kP = kP;
    }

    public double getkI() {
        return this.kI;
    }

    public void setkI(double kI) {
        this.kI = kI;
    }

    public double getkD() {
        return this.kD;
    }

    public void setkD(double kD) {
        this.kD = kD;
    }

    public void setSetpoint(double value) {
        this.setpoint = value;
    }

    public double getSetpoint() {
        return this.setpoint;
    }

    public double getIntegralAccumulation() {
        return this.integralAccumulation;
    }

    public void resetIntegralAccumulation() {
        this.integralAccumulation = 0.0;
    }

    public void resetPreviousMeasurement() {
        this.lastMeasurement = 0.0;
        this.lastSetpoint = this.setpoint;
    }

    public void reset() {
        this.resetIntegralAccumulation();
        this.resetPreviousMeasurement();
    }

    public void setSetpointTolerance(double positionTolerance, double velocityTolerance) {
        this.positionTolerance = positionTolerance;
        this.velocityTolerance = velocityTolerance;
    }

    public double getSetpointPositionTolerance() {
        return this.positionTolerance;
    }

    public double getSetpointVelocityTolerance() {
        return this.velocityTolerance;
    }

    public double getCurrentState() {
        return this.lastMeasurement;
    }

    public double calculate(double measurement, double dt) {
        this.integralAccumulation += dt * (this.setpoint - measurement);
        this.velocity = dt == 0.0 ? 0.0 : (this.setpoint - measurement - (this.lastSetpoint - this.lastMeasurement)) / dt;
        double p = this.kP * (this.setpoint - measurement);
        double i = this.kI * this.integralAccumulation;
        double d = this.kD * this.velocity;
        this.lastMeasurement = measurement;
        this.lastSetpoint = this.setpoint;
        return p + i + d;
    }

    public double calculate(double measurement) {
        return this.calculate(measurement, 0.02);
    }

    public boolean isAtSetpoint() {
        return Math.abs(this.setpoint - this.lastMeasurement) < Math.abs(this.positionTolerance * this.setpoint) && Math.abs(this.velocity) < Math.abs(this.velocityTolerance * this.setpoint);
    }

    public static class PIDConstants {
        private final double kP;
        private final double kI;
        private final double kD;

        public PIDConstants(double kP, double kI, double kD) {
            this.kP = kP;
            this.kI = kI;
            this.kD = kD;
        }

        public double getkP() {
            return this.kP;
        }

        public double getkI() {
            return this.kI;
        }

        public double getkD() {
            return this.kD;
        }

        public boolean equals(Object other) {
            double epsilon = 1.0E-4;
            if (other instanceof PIDConstants) {
                PIDConstants rhs = (PIDConstants)other;
                return Math.abs(this.kP - rhs.kP) < epsilon && Math.abs(this.kI - rhs.kI) < epsilon && Math.abs(this.kD - rhs.kD) < epsilon;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.kP, this.kI, this.kD);
        }

        public String toString() {
            return "PIDConstants: " + this.kP + ", " + this.kI + ", " + this.kD;
        }
    }
}

