/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.controllers;

import org.chsrobotics.lib.controllers.PID;
import org.chsrobotics.lib.trajectory.MotionProfile;

public class MotionProfilePID {
    private final PID controller;
    private final MotionProfile profile;
    private double reference;
    private double lastReference = 0.0;

    public MotionProfilePID(PID.PIDConstants constants, MotionProfile profile) {
        this.controller = new PID(constants, profile.calculate((double)0.0).position);
        this.profile = profile;
    }

    public MotionProfilePID(double kP, double kI, double kD, MotionProfile profile) {
        this.controller = new PID(kP, kI, kD, profile.calculate((double)0.0).position);
        this.profile = profile;
    }

    public void setConstants(double kP, double kI, double kD) {
        this.controller.setConstants(kP, kI, kD);
    }

    public PID.PIDConstants getConstants() {
        return this.controller.getConstants();
    }

    public void setConstants(PID.PIDConstants constants) {
        this.controller.setConstants(constants);
    }

    public double getKP() {
        return this.controller.getkP();
    }

    public void setKP(double kP) {
        this.controller.setkP(kP);
    }

    public double getKI() {
        return this.controller.getkI();
    }

    public void setKI(double kI) {
        this.controller.setkI(kI);
    }

    public double getKD() {
        return this.controller.getkD();
    }

    public void setKD(double kD) {
        this.controller.setkD(kD);
    }

    public MotionProfile.State getSetpoint(double time) {
        return this.profile.calculate(time);
    }

    public MotionProfile.State getSetpoint() {
        return this.profile.calculate(this.reference);
    }

    public double getIntegralAccumulation() {
        return this.controller.getIntegralAccumulation();
    }

    public void resetIntegralAccumulation() {
        this.controller.resetIntegralAccumulation();
    }

    public void resetPreviousMeasurement() {
        this.controller.resetPreviousMeasurement();
    }

    public void reset() {
        this.controller.reset();
        this.lastReference = 0.0;
        this.reference = 0.0;
    }

    public void setSetpointTolerance(double positionTolerance) {
        this.controller.setSetpointTolerance(positionTolerance, 0.0);
    }

    public double getSetpointPositionTolerance() {
        return this.controller.getSetpointPositionTolerance();
    }

    public double getCurrentState() {
        return this.controller.getCurrentState();
    }

    public double calculate(double measurement, double reference) {
        this.controller.setSetpoint(this.profile.calculate((double)reference).position);
        double effort = this.controller.calculate(measurement, reference - this.lastReference);
        this.lastReference = reference;
        return effort;
    }

    public double calculate(double measurement, double reference, double dt) {
        this.controller.setSetpoint(this.profile.calculate((double)reference).position);
        double effort = this.controller.calculate(measurement, dt);
        this.lastReference = reference;
        return effort;
    }

    public boolean isAtSetpoint() {
        return Math.abs(this.profile.calculate((double)this.profile.totalTime()).position - this.controller.getCurrentState()) < Math.abs(this.controller.getSetpointPositionTolerance() * this.profile.calculate((double)this.profile.totalTime()).position);
    }
}

