/*
 * Decompiled with CFR 0.152.
 */
package org.chsrobotics.lib.commands;

import edu.wpi.first.wpilibj2.command.CommandBase;
import edu.wpi.first.wpilibj2.command.Subsystem;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.chsrobotics.lib.util.Tuple2;

public class ConditionalEndConsumerCommand<T>
extends CommandBase {
    private final boolean isBiConsumer;
    private final Consumer<T> consumer;
    private final BiConsumer<T, T> biConsumer;
    private final Supplier<Boolean> endConditional;
    private final T init;
    private final T end;
    private final Tuple2<T> biInit;
    private final Tuple2<T> biEnd;
    private boolean runsWhileDisabled = false;

    public ConditionalEndConsumerCommand(Consumer<T> consumer, T init, T end, Supplier<Boolean> endConditional, Subsystem ... toRequire) {
        this.isBiConsumer = false;
        this.consumer = consumer;
        this.biConsumer = null;
        this.init = init;
        this.end = end;
        this.biInit = null;
        this.biEnd = null;
        this.endConditional = endConditional;
        this.addRequirements(toRequire);
    }

    public ConditionalEndConsumerCommand(BiConsumer<T, T> biConsumer, Tuple2<T> init, Tuple2<T> end, Supplier<Boolean> endConditional, Subsystem ... toRequire) {
        this.isBiConsumer = true;
        this.biConsumer = biConsumer;
        this.consumer = null;
        this.init = null;
        this.end = null;
        this.biInit = init;
        this.biEnd = end;
        this.endConditional = endConditional;
        this.addRequirements(toRequire);
    }

    public void setRunsWhileDisabled(boolean runsWhileDisabled) {
        this.runsWhileDisabled = runsWhileDisabled;
    }

    public boolean runsWhenDisabled() {
        return this.runsWhileDisabled;
    }

    public void initialize() {
        if (this.isBiConsumer && this.biConsumer != null) {
            this.biConsumer.accept(this.biInit.firstValue(), this.biInit.secondValue());
        } else if (this.consumer != null) {
            this.consumer.accept(this.init);
        }
    }

    public void end(boolean interrupted) {
        if (this.isBiConsumer && this.biEnd != null && this.biConsumer != null) {
            this.biConsumer.accept(this.biEnd.firstValue(), this.biEnd.secondValue());
        } else if (this.end != null && this.consumer != null) {
            this.consumer.accept(this.end);
        }
    }

    public boolean isFinished() {
        return this.endConditional.get();
    }
}

