/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.google.utils.geocode;

import java.util.List;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.chenillekit.google.utils.JSONArray;
import org.chenillekit.google.utils.JSONException;
import org.chenillekit.google.utils.JSONObject;
import org.chenillekit.google.utils.geocode.Placemark;
import org.chenillekit.google.utils.geocode.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoCodeResult {
    public static int G_GEO_SUCCESS = 200;
    public static int G_GEO_BAD_REQUEST = 400;
    public static int G_GEO_SERVER_ERROR = 500;
    public static int G_GEO_MISSING_QUERY = 601;
    public static int G_GEO_MISSING_ADDRESS = 601;
    public static int G_GEO_UNKNOWN_ADDRESS = 602;
    public static int G_GEO_UNAVAILABLE_ADDRESS = 603;
    public static int G_GEO_UNKNOWN_DIRECTIONS = 604;
    public static int G_GEO_BAD_KEY = 610;
    public static int G_GEO_TOO_MANY_QUERIES = 620;
    private String name;
    private Status status;
    private List<Placemark> placemarks = CollectionFactory.newList();

    public GeoCodeResult(JSONObject geoCodeResult) {
        this.buildFromJSON(geoCodeResult);
    }

    private void buildFromJSON(JSONObject json) {
        try {
            this.name = json.getString("name");
            this.status = new Status(json.getJSONObject("Status"));
            if (json.has("Placemark")) {
                JSONArray jsonArray = json.getJSONArray("Placemark");
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this.placemarks.add(new Placemark(jsonArray.getJSONObject(i)));
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<Placemark> getPlacemarks() {
        return this.placemarks;
    }
}

