/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.query.service;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.chenile.base.exception.NotFoundException;
import org.chenile.core.context.ContextContainer;
import org.chenile.query.model.ColumnMetadata;
import org.chenile.query.model.QueryMetadata;
import org.chenile.query.model.SearchRequest;
import org.chenile.query.model.SearchResponse;
import org.chenile.query.model.SortCriterion;
import org.chenile.query.service.QueryStore;
import org.chenile.query.service.SearchService;
import org.chenile.query.service.error.ErrorCodes;
import org.chenile.stm.State;
import org.chenile.stm.StateEntity;
import org.chenile.stm.impl.STMActionsInfoProvider;
import org.chenile.workflow.api.WorkflowRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractSearchServiceImpl
implements SearchService<Map<String, Object>> {
    Logger logger = LoggerFactory.getLogger(AbstractSearchServiceImpl.class);
    protected static final String PAGINATION_PART = "pagination";
    protected static final String ORDER_BY = "orderby";
    protected QueryStore queryStore;
    @Autowired
    protected ContextContainer contextContainer;

    public AbstractSearchServiceImpl(QueryStore queryStore) {
        this.queryStore = queryStore;
    }

    @Override
    public final SearchResponse search(SearchRequest<Map<String, Object>> searchRequest) {
        QueryMetadata queryMetadata = this.queryStore.retrieve(searchRequest.getQueryName());
        if (queryMetadata == null) {
            throw new NotFoundException(ErrorCodes.QUERY_ID_NOT_FOUND.getSubError(), new Object[]{searchRequest.getQueryName()});
        }
        EnhancedSearchRequest esr = new EnhancedSearchRequest(searchRequest);
        this.enhanceFiltersUsingMetadata(esr, queryMetadata);
        this.buildOrderByClause(esr.enhancedFilters, esr.originalSearchRequest.getSortCriteria(), queryMetadata);
        SearchResponse searchResponse = this.makeSearchResponse(queryMetadata, esr);
        searchResponse = this.doSearch(esr, searchResponse, queryMetadata);
        return searchResponse;
    }

    protected void enhanceFiltersUsingMetadata(EnhancedSearchRequest searchInput, QueryMetadata queryMetadata) {
        Map<String, Object> filters;
        searchInput.enhancedFilters = new HashMap<String, Object>();
        Map<String, ColumnMetadata> cmdmap = queryMetadata.getColumnMetadata();
        Map<String, Object> systemFilters = searchInput.originalSearchRequest.getSystemFilters();
        if (systemFilters != null) {
            for (String name : systemFilters.keySet()) {
                ColumnMetadata cmd = cmdmap.get(name);
                Object value = systemFilters.get(name);
                if (null != cmd && cmd.isLikeQuery()) {
                    searchInput.enhancedFilters.put(name, "%" + String.valueOf(value) + "%");
                    continue;
                }
                searchInput.enhancedFilters.put(name, value);
            }
        }
        if (searchInput.originalSearchRequest.isToDoList()) {
            if (!queryMetadata.isToDoList()) {
                this.logger.warn("QueryName: {}. Search specifies todoList but query is not configured to support toDoList", (Object)queryMetadata.getName());
            } else if (queryMetadata.getWorkflowName() == null) {
                this.logger.warn("QueryName: {}. Workflow name is null but it is specified as a toDoList", (Object)queryMetadata.getName());
            } else {
                SortCriterion sc;
                Collection<String> states = this.getAllowedStatesForCurrentUser(queryMetadata.getWorkflowName());
                this.constructContainsQuery(searchInput.enhancedFilters, queryMetadata.getStateColumn(), states);
                ArrayList<SortCriterion> sortCriteria = new ArrayList<SortCriterion>();
                if (queryMetadata.getLateColumn() != null) {
                    sc = new SortCriterion();
                    sc.setName(queryMetadata.getLateColumn());
                    sc.setAscendingOrder(true);
                    sortCriteria.add(sc);
                }
                if (queryMetadata.getTendingLateColumn() != null) {
                    sc = new SortCriterion();
                    sc.setName(queryMetadata.getTendingLateColumn());
                    sc.setAscendingOrder(true);
                    sortCriteria.add(sc);
                }
                if (!sortCriteria.isEmpty()) {
                    searchInput.originalSearchRequest.setSortCriteria(sortCriteria);
                }
            }
        }
        if ((filters = searchInput.originalSearchRequest.getFilters()) == null || cmdmap == null) {
            return;
        }
        for (String name : filters.keySet()) {
            ColumnMetadata cmd = cmdmap.get(name);
            if (cmd == null || !cmd.isFilterable()) {
                this.logger.warn("Warning: Filter name " + name + " is not filterable but has been passed as a filter!");
                continue;
            }
            Object value = filters.get(name);
            if (null == value || value.toString().isEmpty()) continue;
            if (cmd.isLikeQuery()) {
                searchInput.enhancedFilters.put(name, "%" + String.valueOf(value) + "%");
                continue;
            }
            if (cmd.isContainsQuery()) {
                this.constructContainsQuery(searchInput.enhancedFilters, name, value);
                continue;
            }
            if (cmd.isBetweenQuery()) {
                this.constructBetweenQuery(searchInput.enhancedFilters, name, value, cmd);
                continue;
            }
            searchInput.enhancedFilters.put(name, value);
        }
        if (queryMetadata.isFlexiblePropnames()) {
            this.enhanceFiltersWithPropNamesPropValues(searchInput.enhancedFilters);
        }
        this.logger.debug("Filters = " + String.valueOf(searchInput.enhancedFilters));
    }

    protected void constructBetweenQuery(Map<String, Object> enhancedFilters, String name, Object value, ColumnMetadata columnMetadata) {
        String secondStr;
        ArrayList<Object> list;
        if (null == columnMetadata || null == value) {
            return;
        }
        if (value instanceof List) {
            list = (ArrayList<Object>)value;
        } else {
            list = new ArrayList<Object>();
            list.add(value);
        }
        ColumnMetadata.ColumnType columnType = columnMetadata.getColumnType();
        if (columnType == ColumnMetadata.ColumnType.CheckBox || columnType == ColumnMetadata.ColumnType.DropDown) {
            return;
        }
        if (1 == list.size()) {
            list.add(list.get(0));
        }
        Object first = list.get(0);
        Object second = list.get(1);
        String firstStr = null == first ? "" : first.toString().trim();
        String string = secondStr = null == second ? "" : second.toString().trim();
        if (firstStr.isEmpty() && secondStr.isEmpty()) {
            return;
        }
        if (firstStr.isEmpty()) {
            first = second;
        } else if (secondStr.isEmpty()) {
            second = first;
        }
        ArrayList<Object> filterList = new ArrayList<Object>(2);
        if (columnType == ColumnMetadata.ColumnType.Text) {
            filterList.add("%" + String.valueOf(first) + "%");
            filterList.add("%" + String.valueOf(second) + "%");
        } else if (columnType == ColumnMetadata.ColumnType.Number) {
            filterList.add(first);
            filterList.add(second);
        } else if (columnType == ColumnMetadata.ColumnType.Date || columnType == ColumnMetadata.ColumnType.DateTime) {
            filterList.add(firstStr);
            filterList.add(secondStr);
        }
        enhancedFilters.put(name, filterList);
    }

    protected void constructContainsQuery(Map<String, Object> enhancedFilters, String name, Object value) {
        if (value instanceof String[] || value instanceof Collection) {
            enhancedFilters.put(name, value);
            return;
        }
        if (value instanceof String) {
            enhancedFilters.put(name, new String[]{(String)value});
            return;
        }
    }

    protected void enhanceFiltersWithPropNamesPropValues(Map<String, Object> filters) {
        ArrayList<String> propNamesList = new ArrayList<String>();
        ArrayList<CallSite> propValuesList = new ArrayList<CallSite>();
        for (Map.Entry<String, Object> entry : filters.entrySet()) {
            propNamesList.add(entry.getKey());
            propValuesList.add((CallSite)((Object)String.valueOf(entry.getValue())));
        }
        if (!propNamesList.isEmpty()) {
            filters.put("propNames", propNamesList);
            filters.put("propValues", propValuesList);
        }
    }

    protected void buildOrderByClause(Map<String, Object> filters, List<SortCriterion> sortCriteria, QueryMetadata queryMetadata) {
        if (!queryMetadata.isSortable()) {
            return;
        }
        String orderby = "order by 1 ASC";
        if (sortCriteria == null || sortCriteria.isEmpty()) {
            filters.put(ORDER_BY, orderby);
            return;
        }
        int counter = 0;
        int sconSize = sortCriteria.size();
        StringBuilder orberyByStringBuilder = new StringBuilder("order by ");
        for (SortCriterion s : sortCriteria) {
            ++counter;
            if (StringUtils.isNotEmpty((String)s.getName())) {
                orberyByStringBuilder.append(s.getName()).append(s.isAscendingOrder() ? " ASC " : " DESC ");
            } else {
                orberyByStringBuilder.append(s.getIndex()).append(s.isAscendingOrder() ? " ASC " : " DESC ");
            }
            if (counter == sconSize) continue;
            orberyByStringBuilder.append(", ");
        }
        orderby = orberyByStringBuilder.toString();
        filters.put(ORDER_BY, orderby);
    }

    protected abstract SearchResponse doSearch(EnhancedSearchRequest var1, SearchResponse var2, QueryMetadata var3);

    public void setQueryStore(QueryStore queryStore) {
        this.queryStore = queryStore;
    }

    protected SearchResponse makeSearchResponse(QueryMetadata queryMetadata, EnhancedSearchRequest searchInput) {
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setColumnMetadata(queryMetadata.getColumnMetadata());
        searchResponse.setCurrentPage(searchInput.originalSearchRequest.getPageNum());
        searchResponse.setNumRowsInPage(searchInput.originalSearchRequest.getNumRowsInPage());
        searchResponse.setCannedReportName(searchInput.originalSearchRequest.getCannedReportName());
        searchResponse.setHiddenColumns(searchInput.originalSearchRequest.getHiddenColumns());
        return searchResponse;
    }

    public void setContextContainer(ContextContainer contextContainer) {
        this.contextContainer = contextContainer;
    }

    protected List<Map<String, String>> getAllowedActionsForWorkflowEntity(String workflowName, Object obj, String stateColumn, String flowColumn) {
        if (obj == null) {
            return null;
        }
        State state = this.extractStateFromObject(obj, stateColumn, flowColumn);
        if (state == null) {
            this.logger.warn("State for object of type {} is null.", (Object)workflowName);
            return null;
        }
        ArrayList ret = new ArrayList();
        STMActionsInfoProvider provider = WorkflowRegistry.getSTMActionInfoProvider((String)workflowName);
        if (provider == null) {
            this.logger.warn("provider for workflow {} is null.", (Object)workflowName);
            return null;
        }
        List listOfMaps = provider.getAllowedActionsAndMetadata(state);
        if (listOfMaps == null) {
            this.logger.warn("return value from state info provider for workflow {} is null.", (Object)workflowName);
            return null;
        }
        return listOfMaps;
    }

    protected Collection<String> getAllowedStatesForCurrentUser(String workflowName) {
        STMActionsInfoProvider provider = WorkflowRegistry.getSTMActionInfoProvider((String)workflowName);
        return provider.getStatesAllowedForCurrentUser();
    }

    protected State extractStateFromObject(Object obj, String stateColumn, String flowColumn) {
        if (obj instanceof StateEntity) {
            return ((StateEntity)obj).getCurrentState();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            String flowId = (String)map.get(flowColumn);
            String stateId = (String)map.get(stateColumn);
            return new State(stateId, flowId);
        }
        return null;
    }

    private void mergeSearchRequests(SearchRequest<Map<String, Object>> one, SearchRequest<Map<String, Object>> two) {
        if (one == null || two == null) {
            return;
        }
        if (two.getFilters() != null && !two.getFilters().isEmpty()) {
            if (one.getFilters() == null || one.getFilters().isEmpty()) {
                one.setFilters(two.getFilters());
            }
            for (Map.Entry entry : two.getFilters().entrySet()) {
                one.getFilters().put((String)entry.getKey(), entry.getValue());
            }
        }
        if (two.getSortCriteria() != null && !two.getSortCriteria().isEmpty()) {
            if (one.getSortCriteria() == null || one.getSortCriteria().isEmpty()) {
                one.setSortCriteria(two.getSortCriteria());
            }
            for (SortCriterion sortCriterion : two.getSortCriteria()) {
                one.getSortCriteria().add(sortCriterion);
            }
        }
        if (two.getHiddenColumns() != null && !two.getHiddenColumns().isEmpty()) {
            if (one.getHiddenColumns() == null || one.getHiddenColumns().isEmpty()) {
                one.setHiddenColumns(two.getHiddenColumns());
            }
            for (String string : two.getHiddenColumns()) {
                one.getHiddenColumns().add(string);
            }
        }
    }

    protected abstract int processCountQuery(Map<String, Object> var1, SearchResponse var2, QueryMetadata var3);

    protected abstract List<Object> executeQuery(EnhancedSearchRequest var1);

    protected void setPaginationInResponse(SearchResponse searchResponse, int maxRows) {
        searchResponse.setMaxRows(maxRows);
        int page = searchResponse.getCurrentPage();
        int numRowsInPage = searchResponse.getNumRowsInPage();
        int maxPages = Math.round((float)maxRows / (float)numRowsInPage);
        if (0 != maxRows % numRowsInPage) {
            ++maxPages;
        }
        page = 0 != maxRows && page > maxPages ? maxPages : page;
        int startRow = (page - 1) * numRowsInPage + 1;
        searchResponse.setStartRow(startRow);
        searchResponse.setCurrentPage(page);
        searchResponse.setMaxPages(maxPages);
    }

    protected void constructPagination(Map<String, Object> filters, int startRow, int numRowsInPage) {
        filters.put(PAGINATION_PART, "limit " + numRowsInPage + " offset " + (startRow - 1));
    }

    protected static class EnhancedSearchRequest {
        public SearchRequest<Map<String, Object>> originalSearchRequest;
        public Map<String, Object> enhancedFilters;

        public EnhancedSearchRequest(SearchRequest<Map<String, Object>> searchRequest) {
            this.originalSearchRequest = searchRequest;
        }
    }
}

