/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.cucumber.workflow;

import cucumber.api.java.en.Given;
import org.chenile.cucumber.VariableHelper;
import org.chenile.stm.impl.ConfigProviderImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ActiveProfiles;

@ActiveProfiles(value={"unittest"})
public class CucumberWorkflowSteps {
    @Autowired
    ApplicationContext applicationContext;
    ConfigProviderImpl configProvider = null;
    String prefix = "";

    @Given(value="that config strategy is {string}")
    public void that_enablement_strategy_is(String beanName) {
        this.configProvider = (ConfigProviderImpl)this.applicationContext.getBean(beanName);
    }

    @Given(value="that config strategy is {string} with prefix {string}")
    public void that_enablement_strategy_is_with_prefix(String beanName, String prefix) {
        this.configProvider = (ConfigProviderImpl)this.applicationContext.getBean(beanName);
        this.prefix = prefix + ".";
    }

    @Given(value="that a new mandatory activity {string} is added from state {string} to state {string} in flow {string}")
    public void that_a_new_mandatory_activity_is_added_to_state_in_flow(String activityName, String fromStateId, String toStateId, String flowId) throws Exception {
        activityName = VariableHelper.substituteVariables((String)activityName);
        fromStateId = VariableHelper.substituteVariables((String)fromStateId);
        toStateId = VariableHelper.substituteVariables((String)toStateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        System.err.println("+++++++++++++Adding a mandatory activity " + activityName + " fro  state " + fromStateId + " to state " + toStateId + " in flow " + flowId);
        this.configProvider.setProperties("# Add activityName  to fromStateId  that will lead to toStateId\n%s%s.%s.transition.add.%s=%s\n## Make activity mandatory by setting the metadata activity to MANDATORY\n%s%s.%s.%s.meta.activity=MANDATORY\n".formatted(this.prefix, flowId, fromStateId, activityName, toStateId, this.prefix, flowId, fromStateId, activityName));
    }

    @Given(value="that a new optional activity {string} is added from state {string} to state {string} in flow {string}")
    public void that_a_new_optional_activity_is_added_to_state_in_flow(String activityName, String fromStateId, String toStateId, String flowId) throws Exception {
        activityName = VariableHelper.substituteVariables((String)activityName);
        fromStateId = VariableHelper.substituteVariables((String)fromStateId);
        toStateId = VariableHelper.substituteVariables((String)toStateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# Add activityName  to fromStateId  that will lead to toStateId\n%s%s.%s.transition.add.%s=%s\n## Make activity optional by setting the metadata activity to OPTIONAL\n%s%s.%s.%s.meta.activity=OPTIONAL\n".formatted(this.prefix, flowId, fromStateId, activityName, toStateId, this.prefix, flowId, fromStateId, activityName));
    }

    @Given(value="that a new activity completion checker {string} is added from state {string} to state {string} in flow {string}")
    public void that_a_new_activity_completion_checker_is_added_to_state_in_flow(String activityName, String fromStateId, String toStateId, String flowId) throws Exception {
        activityName = VariableHelper.substituteVariables((String)activityName);
        fromStateId = VariableHelper.substituteVariables((String)fromStateId);
        toStateId = VariableHelper.substituteVariables((String)toStateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        System.err.println("+++++++++++++++++Adding a completion checker " + activityName + " fro  state " + fromStateId + " to state " + toStateId + " in flow " + flowId);
        this.configProvider.setProperties("# Add activityName  to fromStateId  that will lead to toStateId\n%s%s.%s.transition.add.%s=%s\n## Make activity mandatory by setting the metadata activity to MANDATORY\n%s%s.%s.%s.meta.activity=COMPLETION_CHECKER\n".formatted(this.prefix, flowId, fromStateId, activityName, toStateId, this.prefix, flowId, fromStateId, activityName));
    }

    @Given(value="that all enablements are cleared")
    public void that_all_enablements_are_cleared() {
        this.configProvider.clear();
    }

    @Given(value="that a new state {string} is added to flow {string}")
    public void that_a_new_state_is_added_to_flow(String stateId, String flowId) throws Exception {
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# Add state to flow\n%sstate.add.%s.in=%s\n".formatted(this.prefix, stateId, flowId));
    }

    @Given(value="that a new transition {string} is added from state {string} to state {string} in flow {string}")
    public void that_a_new_transition_is_added_to_state_in_flow(String eventId, String fromState, String toState, String flowId) throws Exception {
        eventId = VariableHelper.substituteVariables((String)eventId);
        fromState = VariableHelper.substituteVariables((String)fromState);
        toState = VariableHelper.substituteVariables((String)toState);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# Add a new transition eventId from fromState to toState in flowId\n%s%s.%s.transition.add.%s=%s\n".formatted(this.prefix, flowId, fromState, eventId, toState));
    }

    @Given(value="that state {string} in flow {string} is enabled")
    public void that_state_is_enabled(String stateId, String flowId) throws Exception {
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# Enable state\n%s%s.%s.enabled=true\n".formatted(this.prefix, flowId, stateId));
    }

    @Given(value="that state {string} in flow {string} is disabled")
    public void that_state_is_disabled(String stateId, String flowId) throws Exception {
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# Disable state\n%s%s.%s.enabled=false\n".formatted(this.prefix, flowId, stateId));
    }

    @Given(value="that transition {string} in state {string} in flow {string} is enabled")
    public void that_transition_in_state_in_flow_is_enabled(String eventId, String stateId, String flowId) throws Exception {
        eventId = VariableHelper.substituteVariables((String)eventId);
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# enable state transition\n%s%s.%s.%s.enabled=true\n".formatted(this.prefix, flowId, stateId, eventId));
    }

    @Given(value="that transition {string} for state {string} in flow {string} is disabled")
    public void that_transition_for_state_in_flow_is_disabled(String eventId, String stateId, String flowId) throws Exception {
        eventId = VariableHelper.substituteVariables((String)eventId);
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        this.configProvider.setProperties("# disable state transition\n%s%s.%s.%s.enabled=false\n".formatted(this.prefix, flowId, stateId, eventId));
    }

    @Given(value="that state {string} in flow {string} has metadata with key {string} and value {string}")
    public void that_state_in_flow_has_metadata_with_key_value(String stateId, String flowId, String key, String value) throws Exception {
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        key = VariableHelper.substituteVariables((String)key);
        value = VariableHelper.substituteVariables((String)value);
        this.configProvider.setProperties("# introduce metadata with key and value for state\n%s%s.%s.meta.%s=%s\n".formatted(this.prefix, flowId, stateId, key, value));
    }

    @Given(value="that transition {string} from state {string} in flow {string} has metadata with key {string} and value {string}")
    public void that_transition_from_state_in_flow_has_metadata_with_key_value(String eventId, String stateId, String flowId, String key, String value) throws Exception {
        eventId = VariableHelper.substituteVariables((String)eventId);
        stateId = VariableHelper.substituteVariables((String)stateId);
        flowId = VariableHelper.substituteVariables((String)flowId);
        key = VariableHelper.substituteVariables((String)key);
        value = VariableHelper.substituteVariables((String)value);
        this.configProvider.setProperties("# introduce metadata with key and value for state\n%s%s.%s.%s.meta.%s=%s\n".formatted(this.prefix, flowId, stateId, eventId, key, value));
    }
}

