/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.proxy.interceptors;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import org.chenile.base.exception.ServerException;
import org.chenile.base.response.GenericResponse;
import org.chenile.core.context.ChenileExchange;
import org.chenile.core.model.HTTPMethod;
import org.chenile.core.model.OperationDefinition;
import org.chenile.owiz.Command;
import org.chenile.proxy.errorcodes.ErrorCodes;
import org.chenile.proxy.interceptors.ChenileResponseHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpInvoker
implements Command<ChenileExchange> {
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Autowired
    RestTemplateBuilder restTemplateBuilder;
    private ObjectMapper objectMapper = new ObjectMapper();

    public void execute(ChenileExchange exchange) throws Exception {
        OperationDefinition od = exchange.getOperationDefinition();
        HttpHeaders headers = this.extractHeaders(exchange);
        HttpEntity entity = new HttpEntity(exchange.getBody(), (MultiValueMap)headers);
        Object baseURI = (String)exchange.getHeader("REMOTE_URL_BASE");
        String serviceOpName = exchange.getServiceDefinition().getId() + "." + exchange.getOperationDefinition().getName();
        if (!((String)baseURI).startsWith("http://")) {
            baseURI = "http://" + (String)baseURI;
        }
        ResponseEntity httpResponse = null;
        RestTemplate restTemplate = this.getRestTemplate(exchange);
        try {
            httpResponse = restTemplate.exchange((String)baseURI + HttpInvoker.constructUrl(this.contextPath, od.getUrl(), exchange), this.httpMethod(od), entity, exchange.getResponseBodyType(), new Object[0]);
        }
        catch (RestClientException e) {
            Object[] eArgs = new Object[]{baseURI, serviceOpName, e.getMessage()};
            this.setCorrectException(exchange, eArgs, e);
            return;
        }
        this.populateResponse(httpResponse, (String)baseURI, serviceOpName, exchange);
    }

    private void populateResponse(ResponseEntity<GenericResponse<?>> httpResponse, String baseURI, String serviceOpName, ChenileExchange exchange) {
        if (httpResponse.hasBody()) {
            GenericResponse gr = (GenericResponse)httpResponse.getBody();
            exchange.setResponse(gr.getData());
        } else {
            String message = "No body returned for " + httpResponse.toString();
            exchange.setException((Throwable)new ServerException(ErrorCodes.MISSING_BODY.getSubError(), new Object[]{baseURI, serviceOpName}));
        }
    }

    private void setCorrectException(ChenileExchange exchange, Object[] eArgs, RestClientException e) {
        if (exchange.getException() != null) {
            return;
        }
        Throwable t = e.getCause();
        ServerException exc = t instanceof ConnectException || t instanceof UnknownHostException || t.getClass().getName().startsWith("java.net.") ? new ServerException(ErrorCodes.CANNOT_CONNECT.getSubError(), eArgs, (Throwable)e) : new ServerException(ErrorCodes.CANNOT_INVOKE.getSubError(), eArgs, (Throwable)e);
        exchange.setException((Throwable)exc);
    }

    private static String constructUrl(String contextPath, String url, ChenileExchange exchange) {
        while (((String)url).contains("/{")) {
            int startIndex = ((String)url).indexOf("/{");
            int endIndex = ((String)url).indexOf("}");
            String pathVarName = ((String)url).substring(startIndex + 2, endIndex);
            Object pathValue = exchange.getHeader(pathVarName);
            url = ((String)url).substring(0, startIndex + 1) + String.valueOf(pathValue) + ((String)url).substring(endIndex + 1);
        }
        if (contextPath != null && !contextPath.isEmpty()) {
            url = contextPath + (String)url;
        }
        return url;
    }

    private HttpHeaders extractHeaders(ChenileExchange exchange) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        for (Map.Entry entry : exchange.getHeaders().entrySet()) {
            String key = (String)entry.getKey();
            Object obj = entry.getValue();
            headers.add(key, obj.toString());
        }
        return headers;
    }

    private HttpMethod httpMethod(OperationDefinition od) {
        return switch (od.getHttpMethod()) {
            default -> throw new IncompatibleClassChangeError();
            case HTTPMethod.GET -> HttpMethod.GET;
            case HTTPMethod.POST -> HttpMethod.POST;
            case HTTPMethod.DELETE -> HttpMethod.DELETE;
            case HTTPMethod.PUT -> HttpMethod.PUT;
            case HTTPMethod.PATCH -> HttpMethod.PATCH;
        };
    }

    protected RestTemplate getRestTemplate(ChenileExchange chenileExchange) {
        ChenileResponseHandler responseErrorHandler = new ChenileResponseHandler(chenileExchange, this.objectMapper);
        return this.restTemplateBuilder.errorHandler((ResponseErrorHandler)responseErrorHandler).build();
    }
}

