/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.proxy.interceptors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import org.chenile.base.exception.ErrorNumException;
import org.chenile.base.exception.ServerException;
import org.chenile.base.response.GenericResponse;
import org.chenile.core.context.ChenileExchange;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class ChenileResponseHandler
extends DefaultResponseErrorHandler {
    private final ChenileExchange chenileExchange;
    private final ObjectMapper objectMapper;

    public ChenileResponseHandler(ChenileExchange exchange, ObjectMapper objectMapper) {
        this.chenileExchange = exchange;
        this.objectMapper = objectMapper;
    }

    public boolean hasError(ClientHttpResponse httpResponse) throws IOException {
        return !httpResponse.getStatusCode().is2xxSuccessful();
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = HttpStatus.resolve((int)response.getStatusCode().value());
        if (statusCode != null) {
            byte[] body = this.getResponseBody(response);
            if (body.length == 0) {
                ServerException e1 = new ServerException("Error happened in invoking " + this.getEndpointName() + response.getStatusCode().value() + response.getStatusText() + " " + String.valueOf(response.getBody()));
                this.chenileExchange.setException((Throwable)e1);
                return;
            }
            this.parseBody(body, response);
            return;
        }
    }

    protected void parseBody(byte[] body, ClientHttpResponse response) throws IOException {
        try {
            GenericResponse gr = (GenericResponse)this.objectMapper.readValue(body, this.getTypeReference());
            ErrorNumException e1 = new ErrorNumException(gr.getCode(), gr.getSubErrorCode(), gr.getDescription());
            this.chenileExchange.setException((Throwable)e1);
            return;
        }
        catch (Exception e) {
            ServerException e1 = new ServerException("Error happened in invoking " + this.getEndpointName() + response.getStatusCode().value() + response.getStatusText());
            this.chenileExchange.setException((Throwable)e1);
            return;
        }
    }

    protected TypeReference<?> getTypeReference() {
        return new TypeReference<Object>(){

            public Type getType() {
                return ChenileResponseHandler.this.chenileExchange.getResponseBodyType().getType();
            }
        };
    }

    protected String getEndpointName() {
        return this.chenileExchange.getServiceDefinition().getId() + "." + this.chenileExchange.getOperationDefinition().getName();
    }
}

