/*
 * Decompiled with CFR 0.152.
 */
package org.chenile.proxy.builder;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import org.chenile.core.context.ChenileExchange;
import org.chenile.core.context.ChenileExchangeBuilder;
import org.chenile.core.context.HeaderCopier;
import org.chenile.core.model.OperationDefinition;
import org.chenile.core.model.ParamDefinition;
import org.chenile.owiz.OrchExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ProxyBuilder {
    public static final String PROXYMODE = "PROXYMODE";
    public static final String REMOTE_URL_BASE = "REMOTE_URL_BASE";
    @Autowired
    @Qualifier(value="chenileProxyOrchExecutor")
    OrchExecutor<ChenileExchange> chenileProxyOrchExecutor;
    @Autowired
    private ChenileExchangeBuilder chenileExchangeBuilder;

    public <T> T buildProxy(Class<T> interfaceToProxy, String serviceName, HeaderCopier headerCopier, String baseUrl) {
        return this.buildProxy(interfaceToProxy, serviceName, headerCopier, ProxyMode.COMPUTE_DYNAMICALLY, baseUrl);
    }

    public <T> T buildProxy(Class<T> interfaceToProxy, String serviceName, HeaderCopier headerCopier, ProxyMode proxyMode, String baseUrl) {
        ProxyClass proxyClass = new ProxyClass(interfaceToProxy, serviceName, headerCopier, proxyMode, baseUrl);
        Object proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceToProxy}, (InvocationHandler)proxyClass);
        return (T)proxy;
    }

    public static enum ProxyMode {
        LOCAL,
        REMOTE,
        COMPUTE_DYNAMICALLY;

    }

    private class ProxyClass
    implements InvocationHandler {
        private String serviceName;
        private HeaderCopier headerCopier;
        private Class<?> interfaceToProxy;
        private ProxyMode proxyMode;
        private String baseUrl;

        public ProxyClass(Class<?> interfaceToProxy, String serviceName, HeaderCopier headerCopier, ProxyMode proxyMode, String baseUrl) {
            this.headerCopier = headerCopier;
            this.serviceName = serviceName;
            this.interfaceToProxy = interfaceToProxy;
            this.proxyMode = proxyMode;
            this.baseUrl = baseUrl;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!method.getDeclaringClass().equals(this.interfaceToProxy)) {
                return method.invoke((Object)this, args);
            }
            ChenileExchange exchange = ProxyBuilder.this.chenileExchangeBuilder.makeExchange(this.serviceName, method.getName(), this.headerCopier);
            if (args != null) {
                this.populateArgs(exchange, args);
            }
            exchange.setHeader(ProxyBuilder.PROXYMODE, (Object)this.proxyMode);
            exchange.setHeader(ProxyBuilder.REMOTE_URL_BASE, (Object)this.baseUrl);
            ProxyBuilder.this.chenileProxyOrchExecutor.execute((Object)exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
            return exchange.getResponse();
        }

        public String toString() {
            return "ProxyBuilder.Proxy." + this.serviceName;
        }

        private void populateArgs(ChenileExchange exchange, Object[] args) {
            exchange.setApiInvocation(Arrays.asList(args));
            OperationDefinition od = exchange.getOperationDefinition();
            block5: for (int index = 0; index < od.getParams().size(); ++index) {
                ParamDefinition pd = (ParamDefinition)od.getParams().get(index);
                Object arg = args[index];
                switch (pd.getType()) {
                    case HEADER: {
                        exchange.setHeader(pd.getName(), arg);
                        continue block5;
                    }
                    case BODY: {
                        exchange.setBody(arg);
                        continue block5;
                    }
                    case HEADERS: {
                        exchange.setHeaders((Map)arg);
                        continue block5;
                    }
                }
            }
        }
    }
}

