/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.maven.tools;

import ceylon.language.AssertionError;
import com.redhat.ceylon.cmr.api.RepositoryManager;
import com.redhat.ceylon.cmr.ceylon.CeylonUtils;
import com.redhat.ceylon.common.log.Logger;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaRunner;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaRunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.BaseModuleLoaderImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.CmrLogger;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.FlatpathModuleLoader;
import com.redhat.ceylon.maven.tools.ExtendedRunnerOptions;
import java.lang.reflect.Method;
import java.net.URL;

public class JavaRunnerImpl
implements JavaRunner {
    private String module;
    private BaseModuleLoaderImpl moduleLoader;
    private ClassLoader moduleClassLoader;
    private String className;

    public JavaRunnerImpl(RunnerOptions options, String module, String version) {
        this.module = module;
        ExtendedRunnerOptions extOptions = (ExtendedRunnerOptions)options;
        RepositoryManager repositoryManager = CeylonUtils.repoManager().cwd(extOptions.getCwd()).userRepos(options.getUserRepositories()).systemRepo(options.getSystemRepository()).offline(options.isOffline()).noDefaultRepos(options.isNoDefaultRepositories()).overrides(options.getOverrides()).logger((Logger)new CmrLogger(options.isVerbose("cmr"))).buildManager();
        ClassLoader delegateClassLoader = null;
        if (options instanceof JavaRunnerOptions) {
            delegateClassLoader = ((JavaRunnerOptions)options).getDelegateClassLoader();
        }
        this.moduleLoader = new FlatpathModuleLoader(repositoryManager, delegateClassLoader, options.getExtraModules(), options.isVerbose("cmr"));
        this.moduleClassLoader = this.moduleLoader.loadModule(module, version);
        this.className = options.getRun() != null ? options.getRun().replace("::", ".") : (module.equals("default") ? "run_" : module + ".run_");
    }

    public void run(String ... arguments) {
        if (this.moduleClassLoader == null) {
            throw new AssertionError("Cannot call run method after cleanup is called");
        }
        this.invokeMain(this.module, arguments);
    }

    public ClassLoader getModuleClassLoader() {
        if (this.moduleClassLoader == null) {
            throw new AssertionError("Cannot get class loader after cleanup is called");
        }
        return this.moduleClassLoader;
    }

    public void cleanup() {
        this.moduleLoader.cleanup();
        this.moduleLoader = null;
        this.moduleClassLoader = null;
    }

    public URL[] getClassLoaderURLs() {
        return this.moduleLoader.getClassLoaderURLs(this.module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMain(String module, String[] arguments) {
        try {
            Class<?> runClass = this.moduleClassLoader.loadClass(this.className);
            Method main = runClass.getMethod("main", String[].class);
            Thread currentThread = Thread.currentThread();
            ClassLoader oldCcl = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(this.moduleClassLoader);
                main.invoke(null, new Object[]{arguments});
            }
            finally {
                currentThread.setContextClassLoader(oldCcl);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot find main class for module " + module + ": " + this.className, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke main method for module " + module + ": " + this.className, e);
        }
    }
}

