/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.maven.tools;

import com.redhat.ceylon.compiler.java.launcher.Main;
import com.redhat.ceylon.compiler.java.runtime.tools.CompilationListener;
import com.redhat.ceylon.compiler.java.runtime.tools.Compiler;
import com.redhat.ceylon.compiler.java.runtime.tools.CompilerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.JavaCompilerOptions;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.JavaCompilerImpl;
import com.redhat.ceylon.compiler.java.runtime.tools.impl.NullWriter;
import com.redhat.ceylon.compiler.java.tools.CeyloncTaskImpl;
import com.redhat.ceylon.compiler.java.tools.CeyloncTool;
import com.redhat.ceylon.maven.tools.ExtendedCompilerOptions;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.file.JavacFileManager;
import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class JavaCompilerImpl
implements Compiler {
    public boolean compile(CompilerOptions options, CompilationListener listener) {
        CeyloncTool compiler = new CeyloncTool();
        JavaCompilerImpl.CompilationListenerAdapter diagnosticListener = new JavaCompilerImpl.CompilationListenerAdapter(listener);
        NullWriter writer = null;
        if (!options.isVerbose()) {
            writer = new NullWriter();
        }
        JavacFileManager fileManager = compiler.getStandardFileManager((Writer)writer, (DiagnosticListener)diagnosticListener, null, null);
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(options.getFiles());
        CeyloncTaskImpl compilerTask = compiler.getTask(null, (JavaFileManager)fileManager, (DiagnosticListener)diagnosticListener, this.translateOptions(options), (Iterable)options.getModules(), compilationUnits);
        compilerTask.setTaskListener((TaskListener)diagnosticListener);
        Main.ExitState state = compilerTask.call2();
        if (options.isVerbose() && state.abortingException != null) {
            state.abortingException.printStackTrace();
        }
        return state.ceylonState == Main.ExitState.CeylonState.OK;
    }

    private List<String> translateOptions(CompilerOptions options) {
        ExtendedCompilerOptions extOptions;
        ArrayList<String> translatedOptions = new ArrayList<String>();
        if (options.isVerbose()) {
            translatedOptions.add("-verbose");
        }
        for (File sourcePath : options.getSourcePath()) {
            translatedOptions.add("-src");
            translatedOptions.add(sourcePath.getPath());
        }
        for (String rep : options.getUserRepositories()) {
            translatedOptions.add("-rep");
            translatedOptions.add(rep);
        }
        if (options.getOutputRepository() != null) {
            translatedOptions.add("-out");
            translatedOptions.add(options.getOutputRepository());
        }
        if (options.getSystemRepository() != null) {
            translatedOptions.add("-sysrep");
            translatedOptions.add(options.getSystemRepository());
        }
        if (options.getOverrides() != null) {
            translatedOptions.add("-overrides");
            translatedOptions.add(options.getOverrides());
        }
        if (options instanceof JavaCompilerOptions) {
            JavaCompilerOptions javaOptions = (JavaCompilerOptions)options;
            if (javaOptions.isFlatClasspath()) {
                translatedOptions.add("-flat-classpath");
            }
            if (javaOptions.isAutoExportMavenDependencies()) {
                translatedOptions.add("-auto-export-maven-dependencies");
            }
        }
        if ((extOptions = (ExtendedCompilerOptions)options).getJavacOptions() != null) {
            Collections.addAll(translatedOptions, extOptions.getJavacOptions().split("\\s+"));
        }
        if (extOptions.getCwd() != null) {
            translatedOptions.add("-cwd");
            translatedOptions.add(extOptions.getCwd());
        }
        if (extOptions.getResourcePath() != null) {
            for (File resourcePath : extOptions.getResourcePath()) {
                translatedOptions.add("-res");
                translatedOptions.add(resourcePath.getPath());
            }
        }
        return translatedOptions;
    }
}

