/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.maven;

import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.compiler.java.runtime.tools.RunnerOptions;
import com.redhat.ceylon.maven.tools.ExtendedRunnerOptions;
import com.redhat.ceylon.maven.tools.JavaRunnerImpl;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run", defaultPhase=LifecyclePhase.NONE)
public class CeylonRunMojo
extends AbstractMojo {
    @Parameter(property="ceylon.cwd", defaultValue="${project.build.directory}")
    private File cwd;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(required=true)
    private String module;
    @Parameter
    private String[] userRepos;
    @Parameter
    private String[] arguments;
    @Parameter
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            ModuleSpec moduleSpec;
            ExtendedRunnerOptions runnerOptions = new ExtendedRunnerOptions();
            runnerOptions.setVerbose(this.verbose);
            if (this.userRepos != null) {
                for (String userRepo : this.userRepos) {
                    runnerOptions.addUserRepository(userRepo);
                }
            }
            runnerOptions.setCwd(this.cwd);
            try {
                moduleSpec = ModuleSpec.parse((String)this.module, (ModuleSpec.Option[])new ModuleSpec.Option[0]);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Invalid module name " + this.module, e);
            }
            JavaRunnerImpl runner = new JavaRunnerImpl((RunnerOptions)runnerOptions, moduleSpec.getName(), moduleSpec.getVersion());
            try {
                if (this.arguments != null) {
                    runner.run(this.arguments);
                } else {
                    runner.run(new String[0]);
                }
            }
            catch (Exception e) {
                throw new MojoExecutionException("Execution error", e.getCause());
            }
        }
    }
}

