/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.maven;

import com.redhat.ceylon.common.tools.CeylonTool;
import com.redhat.ceylon.common.tools.ModuleSpec;
import com.redhat.ceylon.maven.ModuleImport;
import com.redhat.ceylon.tools.importjar.CeylonImportJarTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;

@Mojo(name="import-dependency", defaultPhase=LifecyclePhase.INITIALIZE)
public class CeylonImportDependencyMojo
extends AbstractMojo {
    @Parameter(required=true)
    protected ModuleImport[] moduleImports;
    @Parameter(property="ceylon.cwd", defaultValue="${project.build.directory}")
    private File cwd;
    @Parameter(defaultValue="modules")
    private String out;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    protected RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project}", readonly=true)
    public MavenProject project;
    @Component
    protected RepositorySystem repoSystem;
    @Component
    protected ProjectDependenciesResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        List dependencies;
        try {
            DefaultDependencyResolutionRequest req = new DefaultDependencyResolutionRequest();
            req.setMavenProject(this.project);
            req.setRepositorySession(this.repoSession);
            DependencyResolutionResult resolution = this.resolver.resolve((DependencyResolutionRequest)req);
            dependencies = resolution.getDependencies();
        }
        catch (DependencyResolutionException e) {
            throw new MojoFailureException("Could not resolve dependencies", (Throwable)e);
        }
        ArrayList<CeylonImportJarTool> tools = new ArrayList<CeylonImportJarTool>();
        ArrayList<ModuleSpec> moduleSpecs = new ArrayList<ModuleSpec>();
        for (ModuleImport moduleImport : this.moduleImports) {
            ArtifactResult result;
            Dependency dependency = moduleImport.getDependency();
            String dependencyVersion = dependency.getVersion();
            if (dependencyVersion == null) {
                for (org.eclipse.aether.graph.Dependency managed : dependencies) {
                    if (!this.safeEquals(managed.getArtifact().getGroupId(), dependency.getGroupId()) || !this.safeEquals(managed.getArtifact().getArtifactId(), dependency.getArtifactId()) || !this.safeEquals(managed.getArtifact().getClassifier(), dependency.getClassifier()) || !this.safeEquals(managed.getArtifact().getExtension(), dependency.getType())) continue;
                    dependencyVersion = managed.getArtifact().getBaseVersion();
                }
            }
            try {
                DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), dependency.getType(), dependencyVersion);
                ArtifactRequest request = new ArtifactRequest();
                request.setArtifact((Artifact)artifact);
                request.setRepositories(Collections.emptyList());
                result = this.repoSystem.resolveArtifact(this.repoSession, request);
            }
            catch (Exception e) {
                MojoExecutionException ex = new MojoExecutionException("Cannot resolve dependency");
                ex.initCause((Throwable)e);
                throw ex;
            }
            CeylonImportJarTool tool = new CeylonImportJarTool();
            if (moduleImport.getDescriptor() != null) {
                tool.setDescriptor(moduleImport.getDescriptor());
            }
            if (moduleImport.getForce()) {
                tool.setForce(true);
            }
            tool.setCwd(this.cwd);
            tool.setOut(this.out);
            tool.setFile(result.getArtifact().getFile());
            String moduleName = moduleImport.getName();
            String moduleVersion = moduleImport.getVersion();
            if (moduleName == null) {
                moduleName = dependency.getGroupId() + "." + dependency.getArtifactId();
            }
            if (moduleVersion == null) {
                moduleVersion = dependencyVersion;
            }
            ModuleSpec moduleSpec = new ModuleSpec(moduleName, moduleVersion);
            moduleSpecs.add(moduleSpec);
            tool.setModuleSpec(moduleSpec);
            tools.add(tool);
        }
        for (int i = 0; i < tools.size(); ++i) {
            CeylonImportJarTool tool = (CeylonImportJarTool)tools.get(i);
            try {
                tool.initialize(new CeylonTool());
                tool.run();
                continue;
            }
            catch (Exception e) {
                MojoExecutionException ex = new MojoExecutionException("Cannot import module " + moduleSpecs.get(i));
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
    }

    private boolean safeEquals(String s, String t) {
        if (s == null) {
            s = "";
        }
        if (t == null) {
            t = "";
        }
        return s.equals(t);
    }
}

