/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.maven;

import com.redhat.ceylon.ceylondoc.CeylonDocTool;
import com.redhat.ceylon.common.tools.CeylonTool;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="doc")
public class CeylonDocMojo
extends AbstractMojo {
    @Parameter
    private String verbose;
    @Parameter(property="ceylon.cwd", defaultValue="${project.build.directory}")
    private File cwd;
    @Parameter(defaultValue="modules")
    private String out;
    @Parameter
    private List<File> sources;
    @Parameter
    private String[] userRepos;
    @Parameter(required=true)
    private String[] modules;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            CeylonDocTool tool = new CeylonDocTool();
            if (this.sources == null) {
                this.sources = Collections.singletonList(new File("src/main/ceylon"));
            }
            tool.setSourceFolders(this.sources);
            tool.setCwd(this.cwd);
            tool.setRepositoryAsStrings(this.userRepos != null ? Arrays.asList(this.userRepos) : null);
            tool.setOut(this.out);
            tool.setVerbose(this.verbose);
            tool.setModuleSpecs(this.modules != null ? Arrays.asList(this.modules) : Collections.emptyList());
            tool.initialize(new CeylonTool());
            tool.run();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Doc tool error", e);
        }
    }
}

