/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.ceylon.maven;

import com.redhat.ceylon.compiler.java.runtime.tools.CompilationListener;
import com.redhat.ceylon.maven.tools.ExtendedCompilerOptions;
import com.redhat.ceylon.maven.tools.JavaCompilerImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

@Mojo(name="compile", defaultPhase=LifecyclePhase.COMPILE)
public class CeylonCompileMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(property="ceylon.cwd", defaultValue="${project.build.directory}")
    private File cwd;
    @Parameter(defaultValue="modules")
    private String out;
    @Parameter
    private List<FileSet> sources;
    @Parameter
    private List<FileSet> resources;
    @Parameter
    private String[] userRepos;
    @Parameter
    private String javacOptions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File included;
        HashSet<File> excluded;
        FileSetManager fileSetManager;
        ArrayList<File> files = new ArrayList<File>();
        ArrayList<File> sourcePaths = new ArrayList<File>();
        ArrayList<File> resourcePaths = new ArrayList<File>();
        if (this.sources != null) {
            fileSetManager = new FileSetManager();
            for (FileSet source : this.sources) {
                File sourcePath = new File(source.getDirectory());
                excluded = new HashSet<File>();
                for (String excludedFile : fileSetManager.getExcludedFiles(source)) {
                    excluded.add(new File(sourcePath, excludedFile));
                }
                for (String includedFile : fileSetManager.getIncludedFiles(source)) {
                    included = new File(sourcePath, includedFile);
                    if (excluded.contains(included)) continue;
                    files.add(included);
                }
                sourcePaths.add(new File(source.getDirectory()));
            }
        } else {
            File sourcePath = new File("src/main/ceylon");
            if (sourcePath.exists() && sourcePath.isDirectory()) {
                this.collectSources(sourcePath, files);
                sourcePaths.add(sourcePath);
            }
        }
        if (this.resources != null) {
            fileSetManager = new FileSetManager();
            for (FileSet resource : this.resources) {
                File resourcePath = new File(resource.getDirectory());
                excluded = new HashSet();
                for (String excludedFile : fileSetManager.getExcludedFiles(resource)) {
                    excluded.add(new File(resourcePath, excludedFile));
                }
                for (String includedFile : fileSetManager.getIncludedFiles(resource)) {
                    included = new File(resourcePath, includedFile);
                    if (excluded.contains(included)) continue;
                    files.add(included);
                }
                resourcePaths.add(new File(resource.getDirectory()));
            }
        }
        if (sourcePaths.size() > 0 && files.size() > 0) {
            this.compile(sourcePaths, resourcePaths, files);
        }
    }

    private void collectSources(File dir, List<File> files) {
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                if (child.isDirectory()) {
                    this.collectSources(child, files);
                    continue;
                }
                if (!child.isFile() || !child.getName().endsWith(".ceylon") && !child.getName().endsWith(".java")) continue;
                files.add(child);
            }
        }
    }

    private void compile(List<File> sourcePath, List<File> resourcePath, List<File> files) throws MojoExecutionException, MojoFailureException {
        JavaCompilerImpl compiler = new JavaCompilerImpl();
        ExtendedCompilerOptions options = new ExtendedCompilerOptions();
        options.setSourcePath(sourcePath);
        options.setResourcePath(resourcePath);
        options.setCwd(this.cwd.getAbsolutePath());
        options.setOutputRepository(this.out);
        if (this.javacOptions != null && this.javacOptions.length() > 0) {
            options.setJavacOptions(this.javacOptions);
        }
        options.setVerbose(this.verbose);
        if (this.userRepos != null) {
            for (String userRepo : this.userRepos) {
                options.addUserRepository(userRepo);
            }
        }
        options.setFiles(files);
        boolean ok = compiler.compile(options, new CompilationListener(){

            public void error(File file, long line, long column, String message) {
                String msg = file != null ? "Compilation error at (" + line + "," + column + ") in " + file.getAbsolutePath() + ":" + message : "Compilation error:" + message;
                System.out.println("ERROR : " + msg);
                CeylonCompileMojo.this.getLog().error((CharSequence)msg);
            }

            public void warning(File file, long line, long column, String message) {
                String msg = file != null ? "Compilation warning at (" + line + "," + column + ") in " + file.getAbsolutePath() + ":" + message : "Compilation warning:" + message;
                CeylonCompileMojo.this.getLog().warn((CharSequence)msg);
                System.out.println(msg);
            }

            public void moduleCompiled(String module, String version) {
                CeylonCompileMojo.this.getLog().info((CharSequence)("Compiled module " + module + "/" + version));
            }
        });
        if (!ok) {
            throw new MojoExecutionException("Compilation failed");
        }
    }
}

