/*
 * Decompiled with CFR 0.152.
 */
package edu.uga.date;

import caseine.tags.ToDo;
import caseine.tags.ToDoIn;
import edu.uga.date.Calendrier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CalendrierTest {
    private Calendrier calc;

    @BeforeEach
    public void setUp() throws Exception {
        this.calc = new Calendrier();
    }

    @Test
    @ToDoIn
    public void testMultipleDe4_RG01() {
        int annee = 2016;
        boolean expected = true;
        this.testBissextile(2016, true);
    }

    @Test
    @ToDoIn
    public void testMultipleDe100_RG02() {
        int annee = 1900;
        boolean expected = false;
        this.testBissextile(1900, false);
    }

    @Test
    @ToDoIn
    public void testMultipleDe400_RG03() {
        int annee = 2000;
        boolean expected = true;
        this.testBissextile(2000, true);
    }

    @Test
    @ToDoIn
    public void testNonBissextile2014_RG01() {
        int annee = 2014;
        boolean expected = false;
        this.testBissextile(2014, false);
    }

    @Test
    @ToDoIn
    public void testNonBissextile2015_RG01() {
        int annee = 2015;
        boolean expected = false;
        this.testBissextile(2015, false);
    }

    @ToDo
    private void testBissextile(int annee, boolean expected) {
        boolean bissextile = this.calc.isBissextile(annee);
        Assertions.assertEquals((Object)expected, (Object)bissextile);
    }
}

