/*
 * Decompiled with CFR 0.152.
 */
package org.jim.jcasbin.domain;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bson.types.ObjectId;
import org.casbin.jcasbin.model.Model;

public class CasbinRule {
    private ObjectId id;
    private String ptype;
    private String v0;
    private String v1;
    private String v2;
    private String v3;
    private String v4;
    private String v5;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CasbinRule that = (CasbinRule)o;
        if (this.ptype != null ? !this.ptype.equals(that.ptype) : that.ptype != null) {
            return false;
        }
        if (this.v0 != null ? !this.v0.equals(that.v0) : that.v0 != null) {
            return false;
        }
        if (this.v1 != null ? !this.v1.equals(that.v1) : that.v1 != null) {
            return false;
        }
        if (this.v2 != null ? !this.v2.equals(that.v2) : that.v2 != null) {
            return false;
        }
        if (this.v3 != null ? !this.v3.equals(that.v3) : that.v3 != null) {
            return false;
        }
        if (this.v4 != null ? !this.v4.equals(that.v4) : that.v4 != null) {
            return false;
        }
        return this.v5 != null ? this.v5.equals(that.v5) : that.v5 == null;
    }

    public int hashCode() {
        int result = this.ptype != null ? this.ptype.hashCode() : 0;
        result = 31 * result + (this.v0 != null ? this.v0.hashCode() : 0);
        result = 31 * result + (this.v1 != null ? this.v1.hashCode() : 0);
        result = 31 * result + (this.v2 != null ? this.v2.hashCode() : 0);
        result = 31 * result + (this.v3 != null ? this.v3.hashCode() : 0);
        result = 31 * result + (this.v4 != null ? this.v4.hashCode() : 0);
        result = 31 * result + (this.v5 != null ? this.v5.hashCode() : 0);
        return result;
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty();
    }

    public void setByIndex(int i, String data) {
        switch (i) {
            case 0: {
                this.ptype = data;
                break;
            }
            case 1: {
                this.v0 = data;
                break;
            }
            case 2: {
                this.v1 = data;
                break;
            }
            case 3: {
                this.v2 = data;
                break;
            }
            case 4: {
                this.v3 = data;
                break;
            }
            case 5: {
                this.v4 = data;
                break;
            }
            case 6: {
                this.v5 = data;
                break;
            }
        }
    }

    public ArrayList<String> toPolicy() {
        ArrayList<String> policy = new ArrayList<String>();
        policy.add(this.ptype);
        if (CasbinRule.hasText(this.v0)) {
            policy.add(this.v0);
        }
        if (CasbinRule.hasText(this.v1)) {
            policy.add(this.v1);
        }
        if (CasbinRule.hasText(this.v2)) {
            policy.add(this.v2);
        }
        if (CasbinRule.hasText(this.v3)) {
            policy.add(this.v3);
        }
        if (CasbinRule.hasText(this.v4)) {
            policy.add(this.v4);
        }
        if (CasbinRule.hasText(this.v5)) {
            policy.add(this.v5);
        }
        return policy;
    }

    public static List<CasbinRule> transformToCasbinRule(Model model) {
        HashSet casbinRules = new HashSet();
        model.model.values().forEach(x -> x.values().forEach(y -> y.policy.forEach(z -> {
            if (z.isEmpty()) {
                return;
            }
            int size = z.size();
            CasbinRule casbinRule = new CasbinRule();
            casbinRule.setPtype(y.key);
            casbinRule.setV0((String)z.get(0));
            if (size >= 2) {
                casbinRule.setV1((String)z.get(1));
            }
            if (size >= 3) {
                casbinRule.setV2((String)z.get(2));
            }
            if (size >= 4) {
                casbinRule.setV3((String)z.get(3));
            }
            if (size >= 5) {
                casbinRule.setV4((String)z.get(4));
            }
            if (size >= 6) {
                casbinRule.setV5((String)z.get(5));
            }
            casbinRules.add(casbinRule);
        })));
        return new ArrayList<CasbinRule>(casbinRules);
    }

    public ObjectId getId() {
        return this.id;
    }

    public String getPtype() {
        return this.ptype;
    }

    public String getV0() {
        return this.v0;
    }

    public String getV1() {
        return this.v1;
    }

    public String getV2() {
        return this.v2;
    }

    public String getV3() {
        return this.v3;
    }

    public String getV4() {
        return this.v4;
    }

    public String getV5() {
        return this.v5;
    }

    public void setId(ObjectId id) {
        this.id = id;
    }

    public void setPtype(String ptype) {
        this.ptype = ptype;
    }

    public void setV0(String v0) {
        this.v0 = v0;
    }

    public void setV1(String v1) {
        this.v1 = v1;
    }

    public void setV2(String v2) {
        this.v2 = v2;
    }

    public void setV3(String v3) {
        this.v3 = v3;
    }

    public void setV4(String v4) {
        this.v4 = v4;
    }

    public void setV5(String v5) {
        this.v5 = v5;
    }
}

