/*
 * Decompiled with CFR 0.152.
 */
package org.jim.jcasbin;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.DeleteOneModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;
import org.bson.conversions.Bson;
import org.casbin.jcasbin.model.Assertion;
import org.casbin.jcasbin.model.Model;
import org.casbin.jcasbin.persist.BatchAdapter;
import org.jim.jcasbin.domain.CasbinRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoAdapter
implements BatchAdapter {
    private static final String DEFAULT_DB_NAME = "casbin";
    private static final String DEFAULT_COL_NAME = "casbin_rule";
    private static final Logger log = LoggerFactory.getLogger(MongoAdapter.class);
    private static final CodecRegistry POJO_CODEC_REGISTRY = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry(), CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{PojoCodecProvider.builder().automatic(true).build()})});
    private final MongoClient mongoClient;
    private final String dbName;
    private final String colName;

    private static String orDefault(String str, String defaultStr) {
        return str == null || str.trim().isEmpty() ? defaultStr : str;
    }

    private static Optional<CasbinRule> fromListRule(List<String> rules) {
        if (rules.size() != 7) {
            log.warn("list rules size [{}] do not match pojo fields", (Object)rules.size());
            return Optional.empty();
        }
        CasbinRule casbinRule = new CasbinRule();
        for (int i = 0; i < rules.size(); ++i) {
            casbinRule.setByIndex(i, rules.get(i));
        }
        return Optional.of(casbinRule);
    }

    public MongoAdapter(MongoClient mongoClient, String dbName) {
        this(mongoClient, dbName, null);
    }

    public MongoAdapter(MongoClient mongoClient, String dbName, String colName) {
        this.mongoClient = mongoClient;
        this.dbName = MongoAdapter.orDefault(dbName, DEFAULT_DB_NAME);
        this.colName = MongoAdapter.orDefault(colName, DEFAULT_COL_NAME);
    }

    protected void clearCollection() {
        this.mongoClient.getDatabase(this.dbName).getCollection(this.colName).drop();
    }

    private MongoCollection<CasbinRule> getCollection() {
        return this.mongoClient.getDatabase(this.dbName).withCodecRegistry(POJO_CODEC_REGISTRY).getCollection(this.colName, CasbinRule.class);
    }

    public void loadPolicy(Model model) {
        Map<String, ArrayList<ArrayList<String>>> policies = this.loading();
        policies.keySet().forEach(k -> {
            Assertion assertion = (Assertion)((Map)model.model.get(k.substring(0, 1))).get(k);
            for (ArrayList policy : (ArrayList)policies.get(k)) {
                assertion.policy.add(policy);
                assertion.policyIndex.put(policy.toString(), assertion.policy.size() - 1);
            }
        });
    }

    Map<String, ArrayList<ArrayList<String>>> loading() {
        FindIterable findAll = this.getCollection().find();
        return StreamSupport.stream(findAll.spliterator(), false).distinct().map(CasbinRule::toPolicy).collect(Collectors.toMap(x -> (String)x.get(0), y -> {
            ArrayList<ArrayList> lists = new ArrayList<ArrayList>();
            y.remove(0);
            lists.add((ArrayList)y);
            return lists;
        }, (oldValue, newValue) -> {
            oldValue.addAll(newValue);
            return oldValue;
        }));
    }

    public void savePolicy(Model model) {
        this.clearCollection();
        List<CasbinRule> casbinRules = CasbinRule.transformToCasbinRule(model);
        this.getCollection().insertMany(casbinRules);
    }

    public void addPolicy(String sec, String ptype, List<String> rule) {
        this.adding(sec, ptype, rule);
    }

    void adding(String sec, String ptype, List<String> rule) {
        ArrayList<String> rules = new ArrayList<String>(rule);
        rules.add(0, ptype);
        for (int i = 0; i < 6 - rule.size(); ++i) {
            rules.add("");
        }
        Optional<CasbinRule> casbinRule = MongoAdapter.fromListRule(rules);
        casbinRule.ifPresent(r -> this.getCollection().insertOne(r));
    }

    public void removePolicy(String sec, String ptype, List<String> rule) {
        if (rule.isEmpty()) {
            return;
        }
        this.removeFilteredPolicy(sec, ptype, 0, rule.toArray(new String[0]));
    }

    void removing(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        if (fieldValues.length == 0) {
            return;
        }
        Document filter = new Document("ptype", (Object)ptype);
        int columnIndex = fieldIndex;
        for (String fieldValue : fieldValues) {
            if (CasbinRule.hasText(fieldValue)) {
                filter.put("v" + columnIndex, (Object)fieldValue);
            }
            ++columnIndex;
        }
        this.getCollection().deleteOne((Bson)filter);
    }

    public void removeFilteredPolicy(String sec, String ptype, int fieldIndex, String ... fieldValues) {
        this.removing(sec, ptype, fieldIndex, fieldValues);
    }

    public void addPolicies(String sec, String ptype, List<List<String>> rules) {
        ArrayList rulesOfRules = new ArrayList(rules.size());
        for (List<String> rule : rules) {
            ArrayList<String> ruleClone = new ArrayList<String>(rule);
            ruleClone.add(0, ptype);
            for (int i = 0; i < 6 - rule.size(); ++i) {
                ruleClone.add("");
            }
            Optional<CasbinRule> casbinRule = MongoAdapter.fromListRule(ruleClone);
            casbinRule.ifPresent(rulesOfRules::add);
        }
        if (!rulesOfRules.isEmpty()) {
            this.getCollection().insertMany(rulesOfRules);
        }
    }

    public void removePolicies(String sec, String ptype, List<List<String>> rules) {
        ArrayList<DeleteOneModel> deleteRequests = new ArrayList<DeleteOneModel>();
        for (List<String> rule : rules) {
            if (rule.isEmpty()) continue;
            Document filter = new Document("ptype", (Object)ptype);
            int columnIndex = 0;
            for (String fieldValue : rule) {
                if (CasbinRule.hasText(fieldValue)) {
                    filter.put("v" + columnIndex, (Object)fieldValue);
                }
                ++columnIndex;
            }
            deleteRequests.add(new DeleteOneModel((Bson)filter));
        }
        if (!deleteRequests.isEmpty()) {
            this.getCollection().bulkWrite(deleteRequests);
        }
    }
}

