/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.spring_web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.cardanofoundation.lob.app.support.spring_web.CustomHttpServletRequestWrapper;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
public class RequestCachingFilter
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        String contentType;
        if (request instanceof HttpServletRequest && ((contentType = (httpServletRequest = (HttpServletRequest)request).getContentType()) == null || !contentType.toLowerCase().startsWith("multipart/"))) {
            CustomHttpServletRequestWrapper wrappedRequest = new CustomHttpServletRequestWrapper(httpServletRequest);
            chain.doFilter((ServletRequest)wrappedRequest, response);
            return;
        }
        chain.doFilter(request, response);
    }
}

