/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.spring_web;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class CustomHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] cachedRequest;

    public CustomHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.cachedRequest = request.getInputStream().readAllBytes();
    }

    public ServletInputStream getInputStream() {
        return new CachedServletInputStream(this.cachedRequest);
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(this.cachedRequest)));
    }

    private static class CachedServletInputStream
    extends ServletInputStream {
        private final ByteArrayInputStream byteArrayInputStream;

        public CachedServletInputStream(byte[] cachedRequest) {
            this.byteArrayInputStream = new ByteArrayInputStream(cachedRequest);
        }

        public boolean isFinished() {
            return this.byteArrayInputStream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener listener) {
        }

        public int read() {
            return this.byteArrayInputStream.read();
        }
    }
}

