/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.collections;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Partitions {
    public static <T> Iterable<Partition<T>> partition(Iterable<T> it, int size) {
        return Partitions.toPartitionList(Iterables.partition(it, (int)size));
    }

    private static <T> List<Partition<T>> toPartitionList(Iterable<? extends Iterable<T>> iterable) {
        ArrayList<Partition<T>> partitionList = new ArrayList<Partition<T>>();
        int partitionIndex = 0;
        for (Iterable<T> partition : iterable) {
            partitionList.add(new Partition<T>(partition, ++partitionIndex, Iterables.size(iterable)));
        }
        return partitionList;
    }

    public static class Partition<T> {
        private final Iterable<T> elements;
        private final int partitionIndex;
        private final int totalPartitions;

        public Set<T> asSet() {
            return Sets.newHashSet(this.elements);
        }

        public boolean isFirst() {
            return this.partitionIndex == 1;
        }

        public boolean isLast() {
            return this.partitionIndex == this.totalPartitions;
        }

        public Partition(Iterable<T> elements, int partitionIndex, int totalPartitions) {
            this.elements = elements;
            this.partitionIndex = partitionIndex;
            this.totalPartitions = totalPartitions;
        }

        public Iterable<T> getElements() {
            return this.elements;
        }

        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        public int getTotalPartitions() {
            return this.totalPartitions;
        }
    }
}

