/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.calc;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import org.cardanofoundation.lob.app.support.calc.Summable;

public final class BigDecimals {
    public static BigDecimal sum(BigDecimal ... values) {
        return Summable.sum((Summable[])Arrays.stream(values).filter(Objects::nonNull).map(value -> () -> value).toArray(Summable[]::new));
    }

    public static BigDecimal sum(Summable ... values) {
        return Summable.sum(values);
    }

    public static BigDecimal normalise(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.setScale(8, 4).stripTrailingZeros();
    }

    public static String normaliseEngineeringString(BigDecimal dec) {
        return BigDecimals.normalise(dec).toEngineeringString();
    }

    public static String normaliseString(BigDecimal dec) {
        return BigDecimals.normalise(dec).toPlainString();
    }

    private BigDecimals() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

