/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.reactive;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.cardanofoundation.lob.app.support.reactive.Debouncer;
import org.cardanofoundation.lob.app.support.reactive.TransactionalTaskRunner;

public class DebouncerManager {
    private final TransactionalTaskRunner transactionalTaskRunner;
    private final Cache<String, Debouncer> debouncerCache;

    public DebouncerManager(Duration duration, TransactionalTaskRunner transactionalTaskRunner) {
        this.debouncerCache = CacheBuilder.newBuilder().expireAfterAccess(duration.toMillis(), TimeUnit.MILLISECONDS).removalListener(notification -> {
            Debouncer debouncer = (Debouncer)notification.getValue();
            if (debouncer != null) {
                debouncer.shutdown();
            }
        }).build();
        this.transactionalTaskRunner = transactionalTaskRunner;
    }

    public Debouncer getDebouncer(String id, Runnable task, Duration delay) throws ExecutionException {
        return (Debouncer)this.debouncerCache.get((Object)id, () -> new Debouncer(task, delay, this.transactionalTaskRunner));
    }

    public void cleanup() {
        this.debouncerCache.cleanUp();
    }

    public void callInNewDebouncer(String id, Runnable task, Duration delay) {
        this.debouncerCache.asMap().compute(id, (key, existing) -> {
            if (existing != null) {
                existing.shutdown();
            }
            Debouncer newDebouncer = new Debouncer(task, delay, this.transactionalTaskRunner);
            newDebouncer.call();
            return newDebouncer;
        });
    }
}

