/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.reactive;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.cardanofoundation.lob.app.support.reactive.TransactionalTaskRunner;

public class Debouncer {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> future = null;
    private final Runnable task;
    private final long delay;
    private final TransactionalTaskRunner transactionalTaskRunner;

    public Debouncer(Runnable task, Duration duration, TransactionalTaskRunner transactionalTaskRunner) {
        this.task = task;
        this.delay = duration.toMillis();
        this.transactionalTaskRunner = transactionalTaskRunner;
    }

    public synchronized void call() {
        if (this.future != null && !this.future.isDone()) {
            this.future.cancel(false);
        }
        this.future = this.scheduler.schedule(() -> this.transactionalTaskRunner.runAfterTransaction(this.task), this.delay, TimeUnit.MILLISECONDS);
    }

    public void shutdown() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

