/*
 * Decompiled with CFR 0.152.
 */
package org.cardanofoundation.lob.app.support.orm;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.time.YearMonth;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@Converter(autoApply=true)
public class YearMonthStringAttributeConverter
implements AttributeConverter<YearMonth, String> {
    @Nullable
    public String convertToDatabaseColumn(@Nullable YearMonth attribute) {
        if (attribute == null) {
            return null;
        }
        int month = attribute.getMonthValue();
        return String.format("%d-%02d", attribute.getYear(), month);
    }

    @Nullable
    public YearMonth convertToEntityAttribute(@Nullable String dbData) {
        String[] parts;
        if (!StringUtils.isBlank((CharSequence)dbData) && (parts = dbData.split("-")).length == 2) {
            int year = Integer.parseInt(parts[0]);
            int month = Integer.parseInt(parts[1]);
            return YearMonth.of(year, month);
        }
        return null;
    }
}

